<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <?php echo $__env->yieldContent('head'); ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e(siteinfo()->name); ?></title>

    <!-- Early Dark Mode Init - Add this before any other scripts or styles -->
    <script src="<?php echo e(asset('/')); ?>darkmode/darkreader.min.js"></script>

    <script>
        DarkReader.setFetchMethod(window.fetch);

        // Check dark mode preference before page loads
        const isDarkMode = localStorage.getItem('darkMode') === 'true';
        if (isDarkMode) {
            console.log('Dark mode enabled');
            document.documentElement.classList.add('dark-theme');
            DarkReader.enable({
                brightness: 100,
                contrast: 90,
                sepia: 10
            });
        }
    </script>

    <script>
        // Set initial body class based on dark mode preference
        document.addEventListener('DOMContentLoaded', () => {
            if (localStorage.getItem('darkMode') === 'true') {
                document.body.classList.add('dark-theme');
            }
        });
    </script>

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="<?php echo e(asset('/')); ?>plugins/fontawesome-free/css/all.min.css">
    <!-- IonIcons -->
    <link rel="stylesheet" href="<?php echo e(asset('/')); ?>darkmode/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo e(asset('/')); ?>adminlte/css/adminlte.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('/')); ?>plugins/daterangepicker/daterangepicker.css">

    <link rel="icon" type="image/png" href="<?php echo e(asset('storage/company/' . siteinfo()->img_url ?? '')); ?>">
    


    <link rel="stylesheet" href="<?php echo e(asset('/')); ?>plugins/daterangepicker/daterangepicker.css">
    <!-- iCheck for checkboxes and radio inputs -->
    <link rel="stylesheet" href="<?php echo e(asset('/')); ?>plugins/icheck-bootstrap/icheck-bootstrap.min.css">
    <!-- Bootstrap Color Picker -->
    <link rel="stylesheet" href="<?php echo e(asset('/')); ?>plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css">
    <!-- Tempusdominus Bootstrap 4 -->
    <link rel="stylesheet"
        href="<?php echo e(asset('/')); ?>plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="<?php echo e(asset('/')); ?>plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('/')); ?>plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
    <!-- Bootstrap4 Duallistbox -->
    <link rel="stylesheet" href="<?php echo e(asset('/')); ?>plugins/bootstrap4-duallistbox/bootstrap-duallistbox.min.css">
    <!-- BS Stepper -->
    <link rel="stylesheet" href="<?php echo e(asset('/')); ?>plugins/bs-stepper/css/bs-stepper.min.css">
    <!-- dropzonejs -->
    <link rel="stylesheet" href="<?php echo e(asset('/')); ?>plugins/dropzone/min/dropzone.min.css">

    <link rel="stylesheet" href="<?php echo e(asset('/')); ?>css/toastr.min.css">

    <link rel="stylesheet" href="<?php echo e(asset('/')); ?>css/jquery.dataTables.min.css">
    <link href="<?php echo e(asset('css/navbar.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/sidebar.css')); ?>" rel="stylesheet">
    <?php echo $__env->yieldPushContent('styles'); ?>

    

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css"
        integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />


    <style>
        @import  url('https://fonts.googleapis.com/css2?family=Nunito+Sans:opsz,wght@6..12,400;6..12,500;6..12,600;6..12,700;6..12,800&display=swap');

        .opacity-50 {
            opacity: .5;
        }

        .content-wrapper {

            font-family: 'Nunito Sans', sans-serif;

        }

        .dataTableLoader {
            display: none;
        }

        table .tableheader th {
            font-size: 14px;
            text-align: center;
            white-space: nowrap;
            font-weight: normal;
        }

        table#dataTable {
            /* min-height: 330px; */
        }

        div.table-responsive {
            min-height: 250px;
        }

        div#result {
            min-height: 250px;
        }

        div#processing {
            display: none;
            z-index: 99999999;
        }

        div#processing div {
            background: rgba(0, 0, 0, .5);
            position: fixed;
            width: 100vw;
            height: 100vh;
            top: 0;
            left: 0;
            color: #fff;
            text-align: center;
            vertical-align: middle;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .invoicewrapper .invoice {
            padding: 25px;
        }

        .invoiceModal {
            display: none;
            position: fixed;
            z-index: 999;
            background: rgba(0, 0, 0, .5);
            width: 100%;
            height: 100vh;
        }

        .portalInvoiceModal {
            display: none;
            position: fixed;
            z-index: 999;
            background: rgba(0, 0, 0, .5);
            width: 100%;
            height: 100vh;
        }

        .portalmodal {
            position: relative;
            height: 98vh;
            overflow-y: scroll;
            margin-right: -20px;
        }

        body {
            font: 90%/1.45em "Helvetica Neue", HelveticaNeue, Helvetica, Arial, sans-serif !important;
            background: #FFF;
        }

        .custom-switch {
            padding-left: 2.25rem;
            transform: scale(2);
            position: absolute;
            margin-left: 32px;
        }

        td.expired,
        td.deactivated {
            background-color: #dc3545 !important;
            color: #fff;
            text-align: center;
            text-transform: capitalize;
        }

        td.disable {
            background-color: #ffc107 !important;
            color: #fff;
            text-align: center;
            text-transform: capitalize;
        }

        td.active {
            background-color: #28a745 !important;
            color: #fff;
            text-align: center;
            text-transform: capitalize;
        }

        table.dataTable.no-footer {
            border-bottom: initial;
        }

        table.dataTable thead.bg-gray-50 {
            background: #6c757d !important;
            color: #fff;
            font-size: 12px;
            font-weight: bold;
        }


        span.select2-selection.select2-selection--single {
            height: 40px;
        }

        .loader {
            background: rgba(255, 255, 255, 1);
            position: fixed;
            width: 100vw;
            height: 100vh;
            z-index: 99999999999;
            padding-top: 40vh;
            overflow: hidden;
        }

        div#loading {
            display: block;
            width: 100vw;
            background: rgba(0, 0, 0, .5);
            height: 100vh;
            position: fixed;
            z-index: 99;
            color: #fff !important;
            text-align: center;
            padding-top: 50vh;
        }

        .main-sidebar {
            height: inherit;
            min-height: 100%;
            position: fixed !important;
            top: 0;
            height: 100vh !important;
            overflow-x: hidden;


        }


        .spinner {
            display: none;
        }

        .topSearchbar {
            max-height: 50vh;
            padding: 5px;
            overflow-y: auto;
            background: #fff;
            position: absolute;
            top: 3px;
            border: 1px solid #ddd;
            box-shadow: 0 0 10px 1px #999;
            max-width: 100vw;
            right: 5px;
            z-index: 999;
            left: 0;
        }

        .customermodal {
            position: relative;
            height: 98vh;
            overflow-y: scroll;
            margin-right: -20px;
        }

        .zoom-in-out-box {
            animation: zoom-in-zoom-out 5s ease infinite;
        }

        td a,
        td span {
            white-space: nowrap;
        }

        #balanceHints {
            position: fixed;
            width: 200px;
            z-index: 99;
            background: skyblue;
            bottom: 10px
        }

        .companyTitleName a {
            word-break: break-word;
            white-space: break-spaces;
            text-align: left;
            font-size: 16px !important;
        }

        @keyframes  zoom-in-zoom-out {
            0% {
                transform: scale(1, 1);
            }

            50% {
                transform: scale(1.2, 1.2);
            }

            100% {
                transform: scale(1, 1);
            }
        }



        @media (max-width:1024px) {
            ul.pagination {
                zoom: .8;
            }

            nav {
                margin-top: 70px;
            }

            .topFixed {
                position: fixed;
                width: 100%;
                background: #fff;
                z-index: 99;
                left: 0;
                top: 0;
                border-bottom: 1px solid rgba(255, 193, 7, 0.80);
            }

            .full-mobile {
                width: 100%;
            }

            .navbar {
                display: block;
            }

            .modal-content {
                width: 100% !important;
            }
        }


        .elevation-2 {
            box-shadow: none !important;
            border-right: 1px solid #d1d5db;
            background: #FFF;
        }

        .sidebar-collapse>div .companyTitleName {
            display: none !important;
        }


        .theme-toggle {
            padding: 0.5rem;
            border-radius: 0.5rem;
            color: #6c757d;
            background: transparent;
            border: none;
            cursor: pointer;
            transition: all 0.2s;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .theme-toggle:hover {
            background: rgba(67, 97, 238, 0.05);
            color: var(--primary-color);
        }

        .theme-toggle i {
            font-size: 1.25rem;
        }

        /* Animation for icon switch */
        /* .theme-toggle .fa-moon,
        .theme-toggle.dark-mode .fa-sun {
            display: none;
        } */

        .theme-toggle.dark-mode .fa-sun {
            display: inline-block;
        }

        .theme-toggle .fa-sun {
            display: inline-block;
        }

        .loader {
            background: var(--loader-bg, rgba(255, 255, 255, 1));
            position: fixed;
            width: 100vw;
            height: 100vh;
            z-index: 99999999999;
            display: flex;
            flex-direction: column;
            align-items: center;
            transition: background-color 0.3s ease;
        }

        .loader-spinner {
            font-size: 3rem;
            color: var(--loader-color, #4338ca);
            animation: spin 1s linear infinite;
        }

        .loader p {
            margin-top: 1rem;
            font-size: 1.1rem;
            font-weight: 500;
            color: var(--loader-text-color, #4b5563);
        }

        @keyframes  spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        /* Dark mode support */
        .dark-mode .loader {
            --loader-bg: rgba(17, 24, 39, 1);
            --loader-color: #818cf8;
            --loader-text-color: #e5e7eb;
        }

        .spinner {
            display: none;
        }
    </style>
</head>

<?php if(\Request::route()->getName() == 'clients.index'): ?>

    <body class="hold-transition skin-blue sidebar-collapse sidebar-mini">
    <?php else: ?>

        <body class="hold-transition sidebar-mini">
<?php endif; ?>


<div class="loader text-center" id="loader">
    <i class="fas fa-spinner loader-spinner"></i>
    <p>Data Loading...</p>
</div>

<div class="loader text-center" id="processing">
    <i class="fas fa-cog loader-spinner"></i>
    <p>Processing...</p>
</div>

<div class="wrapper">
    <?php if(Auth::user()->hasRole('Admin')): ?>
        <?php if(Auth::user()->id != 1): ?>
            <?php if(config('app.license_check')): ?>
                <?php if(license_check()['info']['client_type'] != 'Lifetime'): ?>
                    <?php if(license_check()['info']['license_check'] && license_check()['total_due'] > 0): ?>
                        <div class="modal fade" id="alertNotification" tabindex="-1" role="dialog"
                            aria-labelledby="alertNotification">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h4 class="modal-title text-center" id="myModalLabel">Payment Notification</h4>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"
                                            id="extend_close"><span aria-hidden="true">&times;</span></button>
                                    </div>
                                    <div class="modal-body">

                                        <div class="alert alert-danger">
                                            <h4 class="text-center">নিরবিচ্ছিন্ন সার্ভিস পেতে বিল পরিশোধ করুন। Due
                                                Amount:
                                                <?php echo e(license_check()['total_due']); ?>. Please <a
                                                    class="btn btn-sm btn-primary"
                                                    href="https://<?php echo e(license_check()['pay_url']); ?>"
                                                    style="text-decoration:none">Pay Now</a></h4>
                                        </div>

                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-default" data-dismiss="modal"
                                            id="extend_close_btn">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            <?php endif; ?>
        <?php endif; ?>
    <?php endif; ?>
    <div class="invoiceModal"></div>
    <div class="portalInvoiceModal"></div>

    <?php echo $__env->make('layout.nav_lte', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layout.leftaside_lte', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php if(siteinfo()->notice_yes_no == 'Yes'): ?>
        <div id="newsTicker" style="overflow: hidden">
            <p class="zoom-in-out-box"
                style="
            color: red;
            font-size: 18px;
            text-align: center;
            margin-top: 15px;
            font-weight: bold;">
                
                <?php if(Auth::user()->hasRole('Admin')): ?>
                    <?php if(config('app.license_check')): ?>
                        <?php if(license_check()['info']['client_type'] != 'Lifetime'): ?>
                            <?php if(license_check()['info']['license_check'] && license_check()['total_due'] > 0): ?>
                                নিরবিচ্ছিন্ন সার্ভিস পেতে বিল পরিশোধ করুন। Due Amount:
                                <?php echo e(license_check()['total_due']); ?> BDT. Please <a class="btn btn-sm btn-primary"
                                    href="https://<?php echo e(license_check()['pay_url']); ?>" style="text-decoration:none">Pay
                                    Now</a>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endif; ?>
            </p>
        </div>
    <?php endif; ?>




    <div class="d-none"><input type="text" id="show_online_offline_in_top_bar"
            value="<?php if(siteinfo()->online_offline_topbar == 'Yes'): ?> Yes <?php else: ?>  No <?php endif; ?>">
    </div>


    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">


        <!-- Content Header (Page header) -->
        <div>
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <?php if(\Request::route()->getName() == 'dashboard'): ?>
                        <?php else: ?>
                            <?php if(isset($page_title)): ?>
                                <?php echo e($page_title); ?>

                            <?php endif; ?>
                        <?php endif; ?>

                    </div><!-- /.col -->

                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <input type="hidden" id="inv_exp_date" value="<?php echo e(license_check()['exp_date']->exp_date ?? ''); ?>">
        <input type="hidden" id="inv_extended_exp_date"
            value="<?php echo e(license_check()['exp_date']->expire_extend ?? ''); ?>">
        <!-- Main content -->
        <div class="content">
            <div class="container-fluid">
                <?php echo $__env->make('layout.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php if(isset($add_button)): ?>
                    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.Custom.Btn','data' => ['url' => $url,'value' => $value,'class' => $class]]); ?>
<?php $component->withName('Custom.Btn'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['url' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($url),'value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($value),'class' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($class)]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                <?php endif; ?>
                <?php echo $__env->yieldContent('content'); ?>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </div>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark elevation-2">


    </aside>
    <!-- /.control-sidebar -->


    <!-- Main Footer -->
    <footer class="main-footer px-5 font-semibold">
        <strong class="tracking-wider">Copyright &copy; <?php echo e(date('Y')); ?> <a href="https://yetfix.com"
                class="tracking-wide">Yetfix
                LTD</a>.</strong>
        All rights reserved.
        <div class="float-right d-none d-sm-inline-block">
            <b>Version</b> 1.0.1
        </div>
    </footer>
</div>


<!-- Modal For Customer Paymnet and all of status e,g - active,deactive -->
<?php echo $__env->make('paymenthistory.paymentModal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('clients.ModalFile.BillCycleChange', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('clients.ModalFile.PackageChange', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('clients.ModalFile.AddOtc', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('clients.ModalFile.DeactiveDateChange', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('clients.ModalFile.PackageChangeWithoutCost', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('clients.ModalFile.ChnageExpireDate', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Modal For Customer Paymnet and all of status e,g - active,deactive end-->


<!-- ./wrapper -->

<!-- REQUIRED SCRIPTS -->

<!-- jQuery -->
<script src="<?php echo e(asset('/')); ?>plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap -->
<script src="<?php echo e(asset('/')); ?>plugins/bootstrap/js/bootstrap.bundle.min.js"></script>


<script src="<?php echo e(asset('/')); ?>plugins/daterangepicker/daterangepicker.js"></script>



<!-- Select2 -->
<script src="<?php echo e(asset('/')); ?>plugins/select2/js/select2.full.min.js"></script>
<!-- Bootstrap4 Duallistbox -->
<script src="<?php echo e(asset('/')); ?>plugins/bootstrap4-duallistbox/jquery.bootstrap-duallistbox.min.js"></script>
<!-- InputMask -->
<script src="<?php echo e(asset('/')); ?>plugins/moment/moment.min.js"></script>
<script src="<?php echo e(asset('/')); ?>plugins/inputmask/jquery.inputmask.min.js"></script>
<!-- date-range-picker -->
<script src="<?php echo e(asset('/')); ?>plugins/daterangepicker/daterangepicker.js"></script>
<!-- bootstrap color picker -->
<script src="<?php echo e(asset('/')); ?>plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="<?php echo e(asset('/')); ?>plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<!-- Bootstrap Switch -->
<script src="<?php echo e(asset('/')); ?>plugins/bootstrap-switch/js/bootstrap-switch.min.js"></script>
<!-- BS-Stepper -->
<script src="<?php echo e(asset('/')); ?>plugins/bs-stepper/js/bs-stepper.min.js"></script>
<!-- dropzonejs -->
<script src="<?php echo e(asset('/')); ?>plugins/dropzone/min/dropzone.min.js"></script>

<!-- AdminLTE -->
<script src="<?php echo e(asset('/')); ?>adminlte/js/adminlte.js"></script>



<script src="<?php echo e(asset('/')); ?>js/toastr.min.js"></script>

<?php echo Toastr::message(); ?>


<!-- OPTIONAL SCRIPTS -->
<script src="<?php echo e(asset('/')); ?>plugins/chart.js/Chart.min.js"></script>
<!-- AdminLTE for demo purposes -->

<!-- AdminLTE dashboard demo (This is only for demo purposes) -->


<script src="<?php echo e(asset('/')); ?>js/jquery.dataTables.main.js"></script>




<!-- Js file for customer payment along with status functionality eg activve,deactive -->
<?php echo $__env->make('clients.JsFile.CustomerAllProperties', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('clients.JsFile.AjaxcloseDelete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('clients.JsFile.PackageChangeExceptcost', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Js file for customer payment along with status functionality eg activve,deactive end-->

<script>
    /*license check for client payment to yefix start*/
    $(window).on('load', function() {
        var exp_date = $('#inv_exp_date').val();
        var extend_exp_date = $('#inv_extended_exp_date').val();
        cd = (new Date()).toISOString().split('T')[0];
        if (exp_date < cd) {
            if (extend_exp_date < cd) {
                $('#alertNotification').modal({
                    backdrop: 'static',
                    keyboard: false
                }, 'show');
                $('#extend_close').hide();
                $('#extend_close_btn').hide();
            } else {
                // $('#alertNotification').modal('show');
                $('#alertNotification').modal({
                    backdrop: 'static',
                    keyboard: false
                }, 'show');
            }
        }
    });
    /*license check for client payment to yefix end*/
</script>
<script>
    function copyToClipboard(clientId) {
        const text = document.getElementById("client-" + clientId).innerText;

        navigator.clipboard.writeText(text).then(() => {
            alert("Payment URL copied to clipboard!");
        }).catch(err => {
            console.error("Failed to copy text: ", err);
        });
    }
</script>

<script>

    // $(document).ready(function () {
    //     $(document).on("click", ".check-reachable", function (e) {
    //         e.preventDefault(); // Prevent default action

    //         let url = "http://10.151.125.2:80";

    //         console.log("Checking URL: " + url);

    //         let newWindow = window.open(url, "_blank");
    //         if (!newWindow || newWindow.closed || typeof newWindow.closed == "undefined") {
    //             toastr.error("Popup blocked! Allow popups and try again.");
    //         } else {
    //             toastr.success("Opening site...");
    //         }
    //     });

    // });
    $(document).ready(function () {
        $(document).on("click", ".check-reachable", function (e) {
            e.preventDefault(); // Prevent default action

            let urltest = $(this).attr("href");

            let targetUrl = "https://10.151.125.2:443"; // Target server URL

            let corsProxy = "https://cors-anywhere.herokuapp.com/";

            let url = targetUrl; // Combine the target URL with the CORS proxy

            if (url && url !== "https://:443") {
                console.log("Checking URL: " + url);
                $.ajax({
                    url: url,
                    type: "HEAD",
                    timeout: 30000, // Prevent long waiting time
                    success: function () {
                        window.location.href = url; // Open the link if reachable
                    },
                    error: function () {
                        toastr.error("The route is not accessible!"); // Show Toastr notification
                    }
                });
            } else {
                toastr.error("Invalid URL!");
            }
        });
    });
</script>

<?php echo $__env->yieldContent('ajax'); ?>

<?php echo $__env->yieldPushContent('js'); ?>

<!-- Dark Mode Implementation -->
<script>
    $(document).ready(function() {
        // Theme Toggle Handler
        const themeToggle = document.getElementById('themeToggle');

        // Update theme toggle button state
        if (localStorage.getItem('darkMode') === 'true') {
            themeToggle.classList.add('dark-mode');
        }

        // Theme Toggle Click Handler
        themeToggle.addEventListener('click', () => {
            if (themeToggle.classList.contains('dark-mode')) {
                DarkReader.disable();
                themeToggle.classList.remove('dark-mode');
                document.documentElement.classList.remove('dark-theme');
                localStorage.setItem('darkMode', 'false');
            } else {
                DarkReader.enable({
                    brightness: 100,
                    contrast: 90,
                    sepia: 10
                });
                themeToggle.classList.add('dark-mode');
                document.documentElement.classList.add('dark-theme');
                localStorage.setItem('darkMode', 'true');
            }
        });

    });

    <?php if(session('message')): ?>
        toastr.success("<?php echo e(session('message')); ?>");
    <?php endif; ?>
</script>
<script>
    const autoDeactiveDateApply = (cid) => {
            const cidOfClient = document.getElementById(`autoDeactiveId-${cid}`);
            const autoDeactiveDate = cidOfClient?.getAttribute('data-autodeactive') || "";
            const deactiveModalPropertiesCid = document.getElementById("deactive_client_id");
            const deactiveModalPropertiesAutoDate = document.getElementById("deactiveDate");

        if (deactiveModalPropertiesCid.value == cid) {
            deactiveModalPropertiesCid.value = "";
            deactiveModalPropertiesAutoDate.value = "";
        } else {
            deactiveModalPropertiesCid.value = cid;
            deactiveModalPropertiesAutoDate.value = autoDeactiveDate !== '01-Jan-1970' ? autoDeactiveDate : "";
        }
    };
</script>
</body>

</html>
<?php /**PATH /var/www/html/utruntech/radius-circle/resources/views/layout/app.blade.php ENDPATH**/ ?>