<?php

namespace App\Imports;

use App\Models\Client;
use App\Models\Clientsinfo;
use App\Models\Pop;
use App\Models\Reseller;
use App\Models\ResellerUser;
use App\Models\User;
use Exception;
use Maatwebsite\Excel\Concerns\Importable;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\ToCollection;

class ClientDelete implements ToCollection
{
    use Importable;

    public function collection(Collection $rows)
    {
        // manager id wise all info delete

        $count = 0;
        DB::beginTransaction();
        try {
            foreach ($rows as $row) {
                $count++;

                $reseller = Reseller::where('id', trim($row[0]))->first();
                $pops = Pop::where('reseller_id', trim($row[0]))->pluck('id')->toArray();

                $check_pop_user = DB::table('pop_user')->whereIn('pop_id', $pops)->pluck('user_id')->toArray();
                User::whereIn('id', $check_pop_user)->delete();

                $check_pop = DB::table('pop_user')->whereIn('pop_id', $pops)->pluck('pop_id')->toArray();
                foreach ($check_pop as $check_pop_id) {
                    DB::statement("DELETE FROM `pop_user` WHERE `pop_id` = $check_pop_id;");
                }

                $clientIds = Client::withTrashed()->whereIn('pop_id', $pops)->pluck('id')->toArray();
                $userIds = Client::withTrashed()->whereIn('id', $clientIds)->pluck('userid')->toArray();

                $cIdsString = implode("','", array_map('addslashes', $clientIds));
                $userIdsString = implode("','", array_map('addslashes', $userIds));

                DB::statement("delete from radcheck where username IN ('$userIdsString')");
                DB::statement("delete from radusergroup where username IN ('$userIdsString')");
                DB::statement("delete from radacct where username IN ('$userIdsString')");
                DB::statement("delete from customer_accounts where client_id IN ('$cIdsString')");
                DB::statement("delete from bill_generates where client_id IN ('$cIdsString')");
                DB::statement("delete from clientsinfo where client_id IN ('$cIdsString')");
                DB::statement("delete from clients where id IN ('$cIdsString')");
                Pop::whereIn('id', $pops)->delete();

                if ($reseller != null) {
                    $check_res_user = ResellerUser::where('reseller_id', $reseller->id)->pluck('user_id')->toArray();
                    User::whereIn('id', $check_res_user)->delete();

                    $check_res = ResellerUser::where('reseller_id', $reseller->id)->pluck('reseller_id')->toArray();
                    foreach ($check_res as $res) {
                        if ($res != null) {
                            DB::statement("DELETE FROM `reseller_user` WHERE `reseller_id` = $res;");
                        }
                    }
                    $reseller->delete();
                }
            }
            DB::commit();
            Artisan::call('cache:clear');
            return response()->json([
                'status' => 'success',
                'message' => 'Successfully Removed The Customer',
            ]);
        } catch (\Throwable $th) {
            dd($th);
            DB::rollback();
            return response()->json([
                'status' => 'error',
                'message' => 'Something is worng',
            ]);
        }
    }
}
