<?php

namespace App\Http\Controllers;

use App\Models\Pop;
use Illuminate\Http\Request;
use App\Models\NewLineRequest;
use Brian2694\Toastr\Facades\Toastr;

class NewLineRequestController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $pops = Pop::all();

        $newLineRequests = NewLineRequest::with('pop', 'package', 'user')->orderBy('id', 'desc')->get();

        if(request('status') == null && request('pop_id') == null){
            $newLineRequests = $newLineRequests->where('status', 'pending');
        }

        if (request('pop_id')) {
            $newLineRequests = $newLineRequests->where('pop_id', request('pop_id'));
        }

        if (request('status')) {
            $newLineRequests = $newLineRequests->where('status', request('status'));
        }


        return view('clients.newclient.index', [
            'page_title' => 'New Line Request',
            'lists' => $newLineRequests,
            'pops' => $pops,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $pops = Pop::all();
        return view('clients.newclient.create', [
            'page_title' => 'Create New Line Request',
            'pops' => $pops,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'address' => 'required',
            'pop_id' => 'required',
            'package_id' => 'required',
            'otc' => 'required|numeric',
            'phone' => 'required',
            'fiber_meter' => 'required|numeric',
            'status' => 'required',
            'notes' => 'nullable',
        ]);
        // dd($request->all());

        $newLineRequest = new NewLineRequest();
        $newLineRequest->name = $request->name;
        $newLineRequest->father_name = $request->father_name;
        $newLineRequest->mother_name = $request->mother_name;
        $newLineRequest->phone = $request->phone;
        $newLineRequest->address = $request->address;
        $newLineRequest->pop_id = $request->pop_id;
        $newLineRequest->package_id = $request->package_id;
        $newLineRequest->otc = $request->otc;
        $newLineRequest->fiver_miter = $request->fiber_meter;
        $newLineRequest->lat = $request->latitude;
        $newLineRequest->long = $request->longitude;
        $newLineRequest->created_by = auth()->user()->id;
        $newLineRequest->status = 'pending';
        $newLineRequest->remarks = $request->notes;
        $newLineRequest->save();

        Toastr::success('New Line Request created successfully');
        return redirect()->route('new-line-request.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\NewLineRequest  $newLineRequest
     * @return \Illuminate\Http\Response
     */
    public function show(NewLineRequest $newLineRequest)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\NewLineRequest  $newLineRequest
     * @return \Illuminate\Http\Response
     */
    public function edit(NewLineRequest $newLineRequest)
    {
        $pops = Pop::all();
        $newLineRequest->load('pop', 'package');
        return view('clients.newclient.edit', [
            'page_title' => 'Edit New Line Request',
            'newLineRequest' => $newLineRequest,
            'pops' => $pops,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\NewLineRequest  $newLineRequest
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, NewLineRequest $newLineRequest)
    {
        $request->validate([
            'name' => 'required',
            'address' => 'required',
            'pop_id' => 'required',
            'package_id' => 'required',
            'otc' => 'required|numeric',
            'phone' => 'required',
            'fiber_meter' => 'required|numeric',
            'status' => 'required',
            'notes' => 'nullable',
        ]);

        $newLineRequest->name = $request->name;
        $newLineRequest->father_name = $request->father_name;
        $newLineRequest->mother_name = $request->mother_name;
        $newLineRequest->phone = $request->phone;
        $newLineRequest->address = $request->address;
        $newLineRequest->pop_id = $request->pop_id;
        $newLineRequest->package_id = $request->package_id;
        $newLineRequest->otc = $request->otc;
        $newLineRequest->fiver_miter = $request->fiber_meter;
        $newLineRequest->lat = $request->latitude;
        $newLineRequest->long = $request->longitude;
        $newLineRequest->remarks = $request->notes;
        $newLineRequest->save();

        Toastr::success('New Line Request updated successfully');
        return redirect()->route('new-line-request.index');
    }

    /**
     * Update only status of the specified resource.
     */
    public function updateStatus(Request $request, NewLineRequest $new_line_request)
    {
        $request->validate([
            'status' => 'required',
        ]);

        $new_line_request->status = $request->status;
        $new_line_request->save();

        Toastr::success('Status updated');
        return redirect()->route('new-line-request.index');
    }

    /**
     * Update only remarks of the specified resource.
     */
    public function updateRemark(Request $request, NewLineRequest $new_line_request)
    {
        $request->validate([
            'remarks' => 'nullable|string',
        ]);

        $new_line_request->remarks = $request->remarks;
        $new_line_request->save();

        Toastr::success('Remarks updated');
        return redirect()->route('new-line-request.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\NewLineRequest  $newLineRequest
     * @return \Illuminate\Http\Response
     */
    public function destroy(NewLineRequest $newLineRequest)
    {
        //
    }
}
