@extends('layout.app')


@section('content')
    <div class="card">

        <div class="card-body">
            <form action="{{ route('subpackage.permissionUpdate', $pop->id) }}" method="POST">
                @method('PUT')
                @csrf

                <input type="hidden" name="reseller_id" value="{{ $pop->id }}">



                <h2 class="font-bold text-center bg-gray-100 border-gray-100 text-3xl">Pop/Zone Name :
                    {{ $pop->popname }}</h2>

                <table class="table table-bordered">
                    <tr class="bg-blue-300 text-center">
                        <th></th>
                        <th>ID</th>
                        <th>Sub Package Name</th>
                        <th>Sub Package Rate</th>
                    </tr>


                    @can('specific_management_services')

                        @foreach ($packages as $p)
                            @if (in_array($p->id, explode(',', $pop->sub_package_list)) == true)
                                <tr>

                                    <td>

                                        <input id="package_{{ $p->id }}" name="package_id[]" type="checkbox"
                                            value="{{ $p->id }}" @if (in_array($p->id, explode(',', $pop->sub_package_list)) == true) checked @endif>
                                    </td>
                                    <td class="text-center">{{ $p->id }} </td>
                                    <td class="text-center">{{ $p->name }} </td>
                                    <td class="text-center">{{ $p->rate }} </td>
                                </tr>
                            @endif
                        @endforeach

                    @else
 @foreach ($packages as $p)
                        <tr>

                            <td>

                                <input id="package_{{ $p->id }}" name="package_id[]" type="checkbox"
                                    value="{{ $p->id }}" @if (in_array($p->id, explode(',', $pop->sub_package_list)) == true) checked @endif>
                            </td>
                            <td class="text-center">{{ $p->id }} </td>
                            <td class="text-center">{{ $p->name }} </td>
                            <td class="text-center">{{ $p->rate }} </td>
                        </tr>
                    @endforeach
                    @endcan

                   
                </table>



                @cannot('specific_management_services')
                    <div class="flex justify-between mt-5 bg-gray-200 p-2">
                        <a href="{{ route('pop.index') }}" class="btn btn-default float-left"><i class="fa fa-arrow-left"></i>
                            Back</a>
                        <input type="submit" class="btn btn-primary float-right" value="Assign Package">
                    </div>
                @endcannot

                <div class="p-5 text-right">
                </div>

            </form>
        </div>
    </div>
@endsection
