<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Purchase extends Model
{
    use HasFactory;
    public function branch()
    {
        return $this->belongsTo('App\Models\Branch', 'branch_id');

    }
    public function items()
    {
        return $this->hasMany('App\Models\PurchaseItem', 'purchase_id');

    }
    public function payments()
    {
        return $this->hasMany('App\Models\Payment', 'purchase_id');

    }
    public function supplier(){
        return $this->belongsTo('App\Models\Supplier', 'supplier_id');
    }

    public function payment_new()
    {
        return $this->hasOne('App\Models\Payment', 'purchase_id');

    }


}
