<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

namespace App\Http\Middleware;

use Brian2694\Toastr\Facades\Toastr;
use Closure;
use Illuminate\Support\Facades\Auth;

class CheckMapPermission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (globalPermission("manage-map") && auth()->user()->hasPermissionTo('network-manage')) {
            return $next($request);
        }
        Toastr::error('You do not have permission to access this page', 'Error');
        return redirect()->route('clientSearch');
    }
}
