<div class="d-flex justify-content-between align-items-center mb-2">
    <div>
        <button class="btn btn-primary" onclick="export2csv()">Download CSV</button>
        <button class="btn btn-danger" onclick="export2pdf()">Download PDF</button>
    </div>
    <div class="amount-container d-flex text-center gap-2 flex-wrap">
        <p class="p-1 border" style="border:2px solid #fed7aa;">Total Row: {{ $clients->count() ?? 0 }}</p>
        <p class="p-1 border" style="border:2px solid #fed7aa;">Total Due: {{ $clients->sum('customer_account_balance_reseller') }} TK</p>
    </div>
</div>

<div id="paymenthistory" class="mt-3">
    <div class="table-responsive">
        <table class="table table-bordered" id="tableDownload">
            <thead>
                <tr>
                    <th>#ID</th>
                    <th>Client Name</th>
                    <th>Username</th>
                    <th>Status</th>
                    <th>Expire Date</th>
                    <th>Reseller</th>
                    <th>Pop</th>
                    <th>Contact</th>
                    <th>Area</th>
                    <th>Due Amount</th>

                </tr>
            </thead>
            <tbody>
                @foreach ($clients as $client)
                    <tr>
                        <td>{{ $client->id }}</td>
                        <td>{{$client->clientsinfo->clients_name}}</td>

                        <td>{{ $client->userid }}</td>
                        <td class="cStatus{{ $client->id }} {{ clientStatusClass($client->clients_status) }}">

                            @if ($client->clients_status == 'active')
                                Active
                            @elseif($client->clients_status == 'deactive')
                                Deactive</span>
                            @elseif($client->clients_status == 'expired')
                                Expired</span>
                            @elseif($client->clients_status == 'disable')
                                Disabled</span>
                            @endif

                        </td>
                        <td>
                            BD: <span class="bdate_exp{{ $client->id }}">{{ date('d-M-Y', strtotime($client->expire_date)) }}</span><br>
                            @if ($client->payment_dadeline != 0)
                                <span class="d-block badge badge-warning">
                                    PD:
                                    {{ \Carbon\Carbon::parse($client->expire_date)->addDay($client->payment_dadeline)->format('d-M-Y') }}
                                </span>
                            @else
                                PD:
                                <span
                                    class="bdate_exp{{ $client->id }}">{{ \Carbon\Carbon::parse($client->expire_date)->addDay($client->payment_dadeline)->format('d-M-Y') }}</span>
                            @endif
                        </td>
                        <td class="no-wrap">
                            @if ($client->pops->experity_check == 'Yes')
                                <span class="d-block badge badge-warning">
                                    {{ $client->pops->reseller->name ?? '' }}
                                </span>
                            @else
                                {{ $client->pops->reseller->name ?? '' }}
                            @endif
                        </td>
                        <td class="no-wrap">
                            @if ($client->pops->experity_check == 'Yes')
                                <span class="d-block badge badge-warning">
                                    {{ $client->pops->popname ?? '' }}
                                </span>
                            @else
                                {{ $client->pops->popname ?? '' }}
                            @endif
                        </td>
                        <td>{{ $client->clientsinfo->contact_no }}</td>
                        <td>{{ $client->clientsinfo->area }}</td>
                        <td>{{ $client->customer_account_balance_reseller}}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>



<!-- Export Scripts -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://unpkg.com/jspdf-autotable@3.6.0/dist/jspdf.plugin.autotable.js"></script>

<script>
    function export2csv() {
        let data = "";
        const tableData = [];
        const rows = document.querySelectorAll("#tableDownload tr");
        for (const row of rows) {
            const rowData = [];
            for (const [index, column] of row.querySelectorAll("th, td").entries()) {
                if ((index + 1) % 3 === 0) {
                    rowData.push('"' + column.innerText + '"');
                } else {
                    rowData.push(column.innerText);
                }
            }
            tableData.push(rowData.join(","));
        }
        data += tableData.join("\n");
        const a = document.createElement("a");
        a.href = URL.createObjectURL(new Blob([data], { type: "text/csv" }));
        a.setAttribute("download", "payment_report.csv");
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }

    function export2pdf() {
        const { jsPDF } = window.jspdf;
        const doc = new jsPDF({ orientation: 'landscape' });

        doc.text("Reseller Payment History", 14, 10);
        doc.autoTable({
            html: "#tableDownload",
            startY: 20,
            theme: "grid",
            headStyles: { fillColor: [22, 160, 133] },
            styles: { fontSize: 7 },
            tableWidth: 'auto'
        });

        doc.save("payment_report.pdf");
    }
</script>

<style>
    .amount-container {
        flex-direction: column;
    }
    @media (min-width: 640px) {
        .amount-container {
            flex-direction: row;
        }
    }
</style>
