@extends('layout.app')


@section('content')

    <div class="mt-2 card">
        <div class="card-body">
            <div class="table-responsive">
            <table id="dataTable" class="table table-bordered">
                <thead>
                    <tr>
                        <th>
                            ID
                        </th>
                        <th class="text-center">
                            Item Category
                        </th>
                        <th class="text-center">
                            Name
                        </th>
                        <th class="text-center">
                            Name(Bangla)
                        </th>
                        <th class="text-center">
                            Short Name
                        </th>
                        <th class="text-center">
                            Code
                        </th>
                        <th class="text-center">
                            Serial No
                        </th>
                        <th class="text-center">
                            Remarks
                        </th>
                        <th class="text-center">
                            Alert Quantity
                        </th>
                        <th class="text-center">
                            Action
                        </th>
                    </tr>
                </thead>
                <tbody>

                    @foreach ($list as $r)

                        <tr>
                            <td class="text-center">
                                {{ $r->id }}
                            </td>
                            <td class="text-center">
                                {{ $r->category->name }}
                            </td>
                            <td class="text-center">
                                {{ $r->name }}
                            </td>
                            <td class="text-center">
                                {{ $r->bn_name }}
                            </td>
                            <td class="text-center">
                                {{ $r->short_name }}
                            </td>
                            <td class="text-center">
                                {{ $r->code }}
                            </td>
                            <td class="text-center">
                                {{ $r->serial_number == 'enable' ? 'Enable' : 'Disable'}}
                            </td>
                            <td class="text-center">
                                {{ $r->remarks }}
                            </td>

                            <td class="text-center">
                                {{ $r->alert_quantity ?? "" }}
                            </td>
                            <td class="text-center">
                                @if ($r->serial_number == 'enable')
                                    <a href="{{ route('serial-no-show-all', $r->id) }}">
                                        <button class="btn btn-primary "> Serial</button>
                                    </a>

                                @endif
                                @can('inventory_edit')
                                    <a href="{{ route('item.edit', $r->id) }}">
                                        <button class="btn btn-success mt-2">Edit</button>
                                    </a>
                                @endcan


                            </td>
                        </tr>

                    @endforeach

                    <!-- More items... -->
                </tbody>
            </table>
            </div>

            {{-- <div class="p-5">
                {{ $list->links() }}
            </div> --}}
        </div>
    </div>





@endsection
