@extends('layout.app')
@section('content')
    <div class="card">
        <div class="card-body">
            <form action="" id="search">
                <div class="row">
                    <input type="hidden" name="username" value="{{ $client }}">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                From Date
                            </label>
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input type="text" name="from_date" value="{{ $start->format('m/d/y') }}"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                To Date
                            </label>
                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input type="text" name="to_date" value="{{ $end->format('m/d/y') }}"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group float-right mt-2">
                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i> Search</button>
                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive" id="result">
                <table id="dataTable" class="table table-bordered table-striped">
                    <thead class="bg-gray-50">
                        <tr>
                            <th>ID</th>
                            <th>Username</th>
                            <th>Client IP</th>
                            <th>MAC Address</th>
                            <th>Download</th>
                            <th>Upload</th>
                            <th>Login</th>
                            <th>Logout</th>
                            <th>Reason</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $total_down = 0;
                            $total_up = 0;
                        @endphp
                        @foreach ($list as $r)
                            <tr>
                                <td>{{ $r->session_id }}</td>
                                <td>{{ $r->username }}</td>
                                <td>{{ $r->ip_address }}</td>
                                <td>{{ $r->mac_address }}</td>
                                <td style="text-align:right">
                                    {{ round(($r->downloaded) ) }} MB
                                </td>
                                <td style="text-align:right">
                                    {{ round(($r->uploaded) ) }} MB
                                </td>
                                <td>{{ $r->session_start_time }}</td>
                                <td>{{ $r->session_end_time }}</td>
                                <td>{{ $r->last_disconnect_reason }}</td>
                                @php($total_down += round(($r->downloaded) ))
                                @php($total_up += round(($r->uploaded) ))
                            </tr>
                        @endforeach
                        <tr>
                            <td colspan="4" style="text-align:right"><strong>Total</strong></td>
                            <td style="text-align:right"><strong>{{ $total_down }}</strong> MB</td>
                            <td style="text-align:right"><strong>{{ $total_up }}</strong> MB</td>
                            <td colspan="3"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('ajax')
    <script type="text/javascript">
        $(document).ready(function() {

            $('#reset').click(function() {
                $('#result').html('');
            });

            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $('body').prepend('<div id="loading">Loading.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('logSearchResult') }}',
                    data: $('#search').serialize(),
                    success: function(result) {

                        $('#result').html(result);
                        $('#loading').remove();
                    }
                });
            });
        });
    </script>
@endsection
