<?php

namespace App\Http\Controllers;

use App\Models\PaymentGetwayCredential;
use App\Services\PaymentGetwayCredentialService;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;

class PaymentGetwayCredentialController extends Controller
{
    public function index($id)
    {
        // dd($id);
        return view('paymentgetway.index',[
            'page_title' => 'Payment Gateway Credential',
            'paymentgetways' => PaymentGetwayCredential::where('reseller_id', $id)->get(),
            'reseller_id' => $id,
        ]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'reseller_id' => 'required',
            'getway_name' => 'required',
            'appkey_publickey' => 'required',
            'secretkey_privatekey' => 'required',
            'username_merchantid' => 'required',
            'password_merchantnumber' => 'required',
            'base_url' => 'required',
            'callback_url' => 'required',
        ]);

        if(PaymentGetwayCredential::where('reseller_id', $request->reseller_id)->where('getway_name', $request->getway_name)->exists()){
            Toastr::error($request->getway_name . ' Payment Gateway Credential Already Added');
            return back();
        }

        $paymentGetway = PaymentGetwayCredentialService::store($request);

        Toastr::success($paymentGetway->getway_name . ' Payment Gateway Credential Added Successfully');
        return back();
    }

    public function edit($id)
    {
        return view('paymentgetway.edit',[
            'page_title' => 'Edit Payment Gateway Credential',
            'paymentgetway' => PaymentGetwayCredential::find($id),
        ]);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'reseller_id' => 'required',
            'getway_name' => 'required',
            'appkey_publickey' => 'required',
            'secretkey_privatekey' => 'required',
            'username_merchantid' => 'required',
            'password_merchantnumber' => 'required',
            'base_url' => 'required',
            'callback_url' => 'required',
        ]);

        $paymentGetway = PaymentGetwayCredentialService::update($request, $id);

        Toastr::success($paymentGetway->getway_name . ' Payment Gateway Credential Updated Successfully');
        return redirect()->route('paymentGetwayCredential', $request->reseller_id);

    }

    public function delete($id)
    {
        $paymentGetway = PaymentGetwayCredential::find($id);
        $paymentGetway->delete();

        Toastr::success('Payment Gateway Credential Deleted Successfully');
        return back();
    }

}
