<?php

namespace App\Http\Controllers;

use App\Models\BillGenerate;
use App\Models\Billpayment;
use App\Models\Client;
use App\Models\Employee;
use App\Models\Income;
use App\Models\OtcPaymentLog;
use App\Models\Pop;
use App\Models\Reseller;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;

class OtcPaymentReportController extends Controller
{

    public function newOtcPaymentReport(){
        $start = today()->firstOfMonth();
        $end = today()->endOfMonth();

        return view('otcPaymentReport.otcReportGenerate', [
            'page_title'        => 'View New OTC Payment History',
            'reseller'          => Reseller::where('reseller_type','own')->get(),
            'employees'         => Employee::all(),
            'start'             => $start,
            'end'               => $end,
            'users' => User::where('email', '!=', 'admin@billingfix.xyz')->where('email', '!=', 'soiket@outlook.com')
                ->where('email', '!=', 'support@yetfix.com')->where('email', '!=', 'rokibulhasan.356@gmail.com')->get(),
        ]);
    }

    public function newOtcPaymentReportSearch(Request $request)
    {

        if ($request->ajax()) {
            $from =  Carbon::parse($request->from_date)->format('Y-m-d 00:00:00');
            $to   = Carbon::parse($request->to_date)->format('Y-m-d 23:59:59');

            // $reseller_id[] = [];

           if($request->reseller_id){
               $reseller_ids[] = $request->reseller_id;
           }

           if($request->reseller_id == null){
              $reseller_ids = Reseller::where('reseller_type','own')->pluck('id');
           }

          if($request->pop_id){
              $pop_ids[] = $request->pop_id;
          }

          if($request->pop_id == null){
              $pop_ids = Pop::whereIn('reseller_id',$reseller_ids)->pluck('id');
          }

          if(isset($request->with_close_id)){
            $clients_ids = Client::list()->whereIn('pop_id',$pop_ids)->withTrashed()->pluck('id');
            // dd($clients_ids);
          }
          if(!isset($request->with_close_id))
          {

              $clients_ids = Client::list()->whereIn('pop_id',$pop_ids)->pluck('id');
          }

         if(isset($request->collected_by)){
                $employee_ids[] = $request->collected_by;
         }

         if(!isset($request->collected_by)){
            $employee_ids = Employee::pluck('id');
         }

         if(isset($request->user_by)){
                $admin_user_ids[] = $request->user_by;
         }

         if(!isset($request->user_by)){
            $admin_user_ids = User::pluck('id');
         }

        //  dd($request->all());
          $otc_payment_logs = OtcPaymentLog::with('client','client.pop','client.reseller','employee','user','billpayment')
                                            ->whereIn('client_id',$clients_ids)
                                            ->whereIn('employee_id',$employee_ids)
                                            ->whereIn('admin_user_id',$admin_user_ids)
                                            ->whereBetween('otc_payment_date',[$from,$to])
                                            ->get();

        $data = [
            'otc_payment_logs' => $otc_payment_logs,
        ];

        // dd($data);
        return view('otcPaymentReport.otcReportGenerateSearch', $data);


        }
    }
}
