<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\ClientRegister;
use Illuminate\Http\Request;

class ClientRegisterController extends Controller
{
    public function index()
    {
        $data = [
            'list' => ClientRegister::all(),
            'page_title' => 'Registered Client List',
        ];

        return view('clientRegister.index', $data);
    }

    public function create()
    {
        return view('clientRegister.register');
    }

    public function store(Request $request)
    {
        // dd($request->all());
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:client_registers',
            'phone' => 'digits:11',
        ]);

        $clientRegister = new ClientRegister();
        $clientRegister->fill($request->all());
        $clientRegister->status = 'Pending';
        $clientRegister->save();

        return redirect()->back()->with('success_message', 'Info added successfully!');
    }

    public function show($id)
    {
        //
    }

    public function clientEdit($id)
    {
        $data = [
            'register' => ClientRegister::find($id),
            'page_title' => 'Registered Client Edit',
        ];

        return view('clientRegister.edit', $data);
    }

    public function clientUpdate(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email|unique:client_registers,email,' . $id,
            'phone' => 'digits:11',
        ]);

        $clientRegister = ClientRegister::find($id);
        $clientRegister->fill($request->all());
        $clientRegister->status = $request->status;
        $clientRegister->update();

        toastr()->success('Info updated successfully!');
        return redirect()->route('clientRegisterList');
    }

    public function clientDestroy($id)
    {
        //
    }

    public function qrCodeGenerate($id)
    {
        $client = Client::findOrFail($id);
        $link = (new CompanyInfoController)->baseUrl() . $client->slug;

        // return \QrCode::size(200)->generate($link);

        $qrCode = \QrCode::size(200)->generate($link);

        return view('clients.qrcode', [
            'client' => $client,
            'qrCode' => $qrCode
        ]);
    }
}
