<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AddUniqueIdToTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {         
        // DB::table('bill_payments')->update(['client_id_time' => DB::raw('CONCAT(client_id, "_", DATE_FORMAT(`created_at`, \'%Y-%m-%d %H:%i\'))')]);


        DB::table('bill_payments')->select('client_id_time', DB::raw('COUNT(*) as count'))->groupBy('client_id_time')->having('count', '>', 1)->get()->each(function ($item) {
            $billPayments = DB::table('bill_payments')->where('client_id_time', $item->client_id_time)->get();
            $i = 1;
            foreach ($billPayments as $billPayment) {
                DB::table('bill_payments')->where('id', $billPayment->id)->update(['client_id_time' => $billPayment->client_id_time . '_' . $i]);
                $i++;
            }
        });


        // DB::table('bill_generates')->update(['client_id_time' => DB::raw('CONCAT(client_id, "_", DATE_FORMAT(`created_at`, \'%Y-%m-%d %H:%i\'))')]);

        DB::table('bill_generates')->select('client_id_time', DB::raw('COUNT(*) as count'))->groupBy('client_id_time')->having('count', '>', 1)->get()->each(function ($item) {
            $billPayments = DB::table('bill_generates')->where('client_id_time', $item->client_id_time)->get();
            $i = 1;
            foreach ($billPayments as $billPayment) {
                DB::table('bill_generates')->where('id', $billPayment->id)->update(['client_id_time' => $billPayment->client_id_time . '_' . $i]);
                $i++;
            }
        });
    }
}
