<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Pop;
use App\Models\Reseller;
use App\Models\SubResellerBalanceLogReport;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\SubResellerRechargeReport;
use App\Models\User;

class SubResellerRechargeReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:sub-reseller-recharge-report',['only' => ['index']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $start = Carbon::now()->today();

        // dd($start);
        $end = today();
        return view('subresellerRecharge.index',[
            'page_title' => 'Sub Manager Recharge',
            'start'      => $start,
            'end'        => $end,
            'reseller'   =>  Reseller::resellerList()->get(),
            'users'      =>  User::where('email', '!=', 'admin@billingfix.xyz')
                                ->where('email', '!=', 'rokibulhasan.356@gmail.com')
                                ->where('email', '!=', 'soiket@outlook.com')
                                ->where('email', '!=', 'support@yetfix.com')
                                ->get(),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function subResellerRechargeSearch(Request $request)
    {
        
        if($request->ajax()){

            // dd($request->all());


            $from = $request->from_date == '' ? today() : Carbon::parse($request->from_date);
            $to   = $request->to_date == '' ? today() : Carbon::parse($request->to_date);


            $from = Carbon::parse($from)->format('Y-m-d 00:00:00');
            $to   = Carbon::parse($to)->format('Y-m-d 23:59:59');

            $poplist = Pop::conditionalList();
            $pop_ids = $poplist->pluck('id')->toArray();

            $list = SubResellerRechargeReport::with('user')
                                            ->whereBetween('created_at',[$from,$to]);

            $user = $request->user == '' ? 'all' : $request->user;


            if($request->reseller==null){

                $list->whereIn('pop_id',$pop_ids);

            }elseif($request->pop == 'all'){

                    $pop = $poplist->whereIn('reseller_id',$request->reseller)->pluck('id')->toArray();

                    $list->whereIn('pop_id',$pop);
            }else{
                $pop = $poplist->whereIn('reseller_id',$request->reseller)->pluck('id')->toArray();
                $list->where('pop_id',$request->pop);
            }

            if($user != 'all'){
                $list->where('user_id',$user);
            }


            return view('subresellerRecharge.result',[
                'list'       =>  $list->get(),
                'pops'       =>  $poplist
            ]);
        }
    }
}
