<?php

namespace App\Http\Controllers;

use App\Models\FormSetting;
use Carbon;
use Illuminate\Http\Request;
use App\Models\GlobalSettings;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Cache;

class GlobalSettingsController extends Controller
{


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {


        if (auth()->user()->id != 1) {
            return redirect()->back();
            abort(404);
        }


        return view('global_settings.globalSettingsList', [
            'list' => GlobalSettings::all()
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        if (auth()->user()->id != 1) {
            return redirect()->back();
            abort(404);
        }

        return view('global_settings.createGlobalSettings', [
            'page_title' => 'Create New Global Settings'
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        if (auth()->user()->id != 1) {
            return redirect()->back();
            abort(404);
        }

        foreach ($request->action as $key => $value) {
            DB::table('global_settings')
                ->where('id', $key)
                ->update([
                    'status' => $value
                ]);
        }

        Cache::forget('globalSettings');

        //tostar
        Toastr::success('Global Settings Update successfully');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        if (auth()->user()->id != 1) {
            return redirect()->back();
            abort(404);
        }
        return view('global_settings.editGlobalSettings', [
            'page_title' => 'Edit Global Settings',
            'globalSettings' => GlobalSettings::find($id)
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {




        if (auth()->user()->id != 1) {
            return redirect()->back();
            abort(404);
        }


        $request->validate([
            'name' => 'required|unique:global_settings,name,' . $id
        ]);

        GlobalSettings::whereId($id)->update([
            'name' => $request->name,
            'status' => $request->status
        ]);

        // Cache::forget('globalSettings');
        Artisan::call('cache:clear');
        

        return redirect()->back()->with('success_message', 'Global Settings updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (auth()->user()->id != 1) {
            return redirect()->back();
            abort(404);
        }


        Cache::forget('globalSettings');
    }

    public function formSetting()
    {
        return view('formSetting.formSetting', [
            'list' => FormSetting::all()
        ]);
    }

    public function formSettingStore(Request $request)
    {
        foreach ($request->action as $key => $value) {
            DB::table('form_settings')
                ->where('id', $key)
                ->update([
                    'status' => $value
                ]);
        }

        Toastr::success('Form Settings Updated Successfully');

        return redirect()->back();
    }
}
