@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <a href="{{ route('marketing-user.create') }}" class="btn-sm btn btn-primary float-right">Add New User</a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="dataTable" class="display">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="text-center">#</th>
                            <th scope="col" class="text-center">First Name</th>
                            <th scope="col" class="text-center">Last Name</th>
                            <th scope="col" class="text-center">Contact</th>
                            <th scope="col" class="text-center"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($list as $r)
                            <tr>
                                <td class="text-center">{{ $loop->iteration }}</td>
                                <td class="text-center">{{ $r->firstname }}</td>
                                <td class="text-center">{{ $r->lastname }}</td>
                                <td class="text-center">{{ $r->contact_no }}</td>
                                <td class="d-flex">

                                    <a href="{{ route('marketing-user.edit', $r->id) }}"
                                        class="btn btn-primary btn-sm">Edit</a>

                                    {{-- @can('marketing_user_destroy')
                                        <form action="{{ route('marketing-user.destroy', $r->id) }}" method="POST"
                                            class="">
                                            @method('DELETE')
                                            @csrf

                                            <button onclick="return confirm('Are you want to delete the marketing user?')"
                                                type="delete" class="btn btn-danger btn-sm">Delete</button>
                                        </form>
                                    @endcan --}}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
