<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dashboard-billing-info')): ?>
    <?php if(getBillingType() == 'day_to_day'): ?>
        <div class="card">
            <div class="card-body">
                <section class="bill-collection-area bg-white pt-2  mt-2 mb-2 pb-2">
                    <h4 class="text-center my-2">Manager (only Own) Approximate Bill
                        <?php echo e(date('M')); ?> <?php echo e(date('Y')); ?></h4>
                    <table class="table table-hover table-responsive-lg">
                        <thead>
                            <tr>
                                <th scope="col" class="h6">Manager Name</th>
                                <th scope="col" class="h6 text-right">Approximate Monthly Bill</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $this_month_bill = 0;
                            ?>

                            <?php $__currentLoopData = $localApproxBill; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $bill = 0;
                                    foreach ($item as $r) {
                                        $bill += $r->total_client * $r->package_rate;
                                    }
                                ?>

                                <tr>
                                    <td class="h6"><?php echo e($item->first()->name); ?></td>
                                    <td class="text-right"><?php echo e($bill); ?></td>
                                </tr>

                                <?php
                                    $this_month_bill += $bill;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <tr class="bg-gray">
                                <td class="h6">Total</td>
                                <td class="h6 text-right"><?php echo e($this_month_bill); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </section>
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?>
<?php /**PATH /var/www/html/southbangla/radius-circle/resources/views/dashboard/new/localApproxBill.blade.php ENDPATH**/ ?>