@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="" id="search" class="resellerRechargeLog">


                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                From Date
                            </label>
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input type="text" name="from_date" value="{{ $start->format('m/d/y') }}"
                                    class="form-control datetimepicker-input input-group-append" data-toggle="datetimepicker"
                                    data-target="#searchFrom" autocomplete="off">

                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                To Date
                            </label>

                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input type="text" name="to_date" value="{{ $end->format('m/d/y') }}"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">

                            </div>


                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Select Manager</label>
                            <select name="reseller" id="reseller" class="select2 form-control">
                                <option value="all">All Manager</option>

                                @foreach ($reseller as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'> POP Name </label>


                        <select name="pop" id="pop" class="form-control select2">
                            <option value=""> ALL POP</option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Username</label>
                            <input type="text" name="username" class="form-control">
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group float-right mt-2">
                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i> Search</button>
                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>




                </div>

                <div id="result">
                    {{-- list will show in this box --}}
                </div>

            </form>
        </div>
    </div>

    {{-- <x-Custom.modal modalTitle="Reseller Recharge">
    <x-Custom.inputGroup inputName="amount" labelName="Amount" labelIcon="" placeholder="0" inputType="number" required="required"/>
    <x-Custom.formUpdateBtn value="Recharge" class="float-right bg-blue-300 mt-2"/>
  </x-Custom.modal> --}}
@endsection



@section('ajax')
    <script type="text/javascript">
        $(function() {
            $('#reset').click(function() {
                $('#result').html('');
            });

            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $('#processing').show();
                $.ajax({
                    type: 'get',
                    url: '{{ route('subResellerBalanceLogReport') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                        $('#processing').hide();

                    }
                });
            });


            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="loading">Loading.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('getSubPopOfReseller') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').html(result);
                        $('#loading').remove();

                    }
                });
            });



        });
    </script>
@endsection
