@extends('layout.app')


@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title" style="color:#115548;">Provider List</h3>
            <div class="card-tools">
                <a href="{{ route('band-provider.create') }}"><button class="btn btn-sm btn-primary"><i
                            class="fa fa-plus-circle" aria-hidden="true"></i> &nbsp; Provider</button></a>
            </div>
        </div>

        <div class="card-body">

            <div class="table-responsive">
                <table id="dataTable" class="display">
                    <thead class="bg-gray-50">
                        <tr>
                            <th> ID </th>
                            <th> Company Name </th>
                            <th> Contact Person </th>
                            <th> Email </th>
                            <th> Phone Number </th>
                            <th> Address </th>
                            <th> Document </th>
                            <th> Action </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach ($list as $row)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $row->company_name }}</td>
                                <td>{{ $row->contact_person }}</td>
                                <td>{{ $row->email }}</td>
                                <td>{{ $row->phone_no }}</td>
                                <td>{{ $row->address }}</td>
                                <td><img style="width: 100px; height: 70px;"
                                        src="{{ asset('storage/bandProvider/' . $row->document) }}"></td>
                                <td style="">
                                    <div class="row">
                                        <div>
                                            <a href="{{ route('band-provider.edit', $row->id) }}"
                                                class="btn btn-warning">Edit</a>
                                        </div>
                                        {{-- <div class="ml-2">
                                            <form method="POST" action="{{ route('band-provider.destroy', $row->id) }}">
                                                @method('delete')
                                                @csrf

                                                <button type="submit" class="btn btn-danger">Delete</button>
                                            </form>
                                        </div> --}}
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
