<div class="mb-2">
    <button class="btn btn-primary" onclick="export2csv()">Download csv</button>
</div>
<div class="col-md-12">
    <div class="badge badge-info float-right m-1" style="text-align: ">Total Row: {{ $list->count() }}</div>
</div>
<div class="table-responsive">
    <table class="table table-bordered table-condensed table-striped" id="tableId">
        <thead class="bg-gray-50">
            <tr>
                <th> SL </th>
                <th> Customer </th>
                <th> B Date </th>
                <th> Total </th>
                <th> Discount </th>
                <th> Paid </th>
                <th> Due </th>
                <th style="width: 100px; ">Action </th>
            </tr>
        </thead>
        <tbody class="bg-white divide-y divide-gray-200">
            @php
                $total = 0;
                $discount = 0;
                $paid = 0;
                $due = 0;
            @endphp
            @foreach ($list as $row)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $row->bandwidthSaleCustomer->customer_name ?? '' }}</td>
                    <td>{{ $row->billing_date }}</td>
                    <td style="text-align: right">{{ $row->total }}</td>
                    <td style="text-align: right">{{ $row->discount }}</td>
                    <td style="text-align: right">{{ $row->paid }}</td>
                    <td style="text-align: right">
                        @php
                            $d_amount = $row->total - ($row->discount + $row->paid);
                        @endphp
                        {{ number_format($d_amount, 2) }}
                    </td>
                    <td style="">
                        <div class="row">
                            <div>
                                <a href="{{ route('bw-sale.edit', $row->id) }}" class="btn btn-primary">Edit</a>
                            </div>
                        </div>
                    </td>
                    @php
                        $total += $row->total;
                        $discount += $row->discount;
                        $paid += $row->paid;
                        $due += $row->total - ($row->discount + $row->paid);
                    @endphp
                </tr>
            @endforeach
            <tr>
                <td></td>
                <td></td>
                <td style="text-align: right"><b>Total</b></td>
                <td style="text-align: right"><b>{{ number_format($total, 2) }}</b></td>
                <td style="text-align: right"><b>{{ number_format($discount, 2) }}</b></td>
                <td style="text-align: right"><b>{{ number_format($paid, 2) }}</b></td>
                <td style="text-align: right"><b>{{ number_format($due, 2) }}</b></td>
                <td></td>
            </tr>
        </tbody>
    </table>
</div>
