<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMapComponentToClientsinfoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('clientsinfo', function (Blueprint $table) {
            $table->string("connected_component_type")->nullable();
            $table->foreignId("connected_component_id")->nullable();

            // this is added to create relation with port, splitter. -> so that they can know it's an client. 
            $table->string("type")->default("client");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('clientsinfo', function (Blueprint $table) {
            $table->dropColumn("connected_component_type");
            $table->dropColumn("connected_component_id");
        });
    }
}
