@extends('layout.app')


@section('content')
    <div class="card">

        <div class="card-body">
            <form action="#" id="search" class="paymentHistory">
                <h4 class="p-2 border-l">{{ $page_title }}</h4>

                <div class="row">
                    <div class="col-md-2 col-sm-4">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                From Date
                            </label>
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input type="text" name="from_date" value="{{ $start->format('m/d/y') }}"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-4">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                To Date
                            </label>
                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input type="text" name="to_date" value="{{ $end->format('m/d/y') }}"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-2 col-sm-4">
                        <div class="form-group">
                            <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Select
                                Manager</label>
                            <select name="reseller_id" id="reseller" class="select2 form-control">
                                <option value="">All Reseller</option>
                                @foreach ($reseller as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-2 col-sm-4">
                        <div class="form-group">
                            <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Select
                                Sub-Manager/Pop</label>
                            <select name="pop_id" id="pop" class="select2 form-control">
                                <option value="">All Pops/Sub-manager</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-2 col-sm-4">
                        <div class="form-group" style="margin-top:40px">
                            <input type="checkbox" name="with_close_id">
                            <span>With Close Id</span>
                        </div>
                    </div>

                    <div class="col-md-2 col-sm-4">
                        <div class="form-group" style="margin-top:40px">
                            <input type="checkbox" name="with_zero_payment">
                            <span>With Zero Payment</span>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group float-right">
                            <button @click="search" class="btn btn-primary" type="submit" id="paymentSearch"><i
                                    class="fa fa-search"></i> Search</button>
                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>
                </div>
            </form>
            <div id="result"></div>
        </div>
    </div>
@endsection


@section('ajax')
    <script>
        $(function() {

            $('#reset').click(function() {
                $('#result').html('');
                $('.select2').val(null).trigger("change");
            });

            $('#reseller').on('change', function() {
                $("#loader").show();
                $.ajax({
                    type: 'get',
                    url: '{{ route('getPopForManager') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(data) {
                        $('#pop option').remove();
                        $('#pop').append(data);
                        $("#loader").hide();
                    }
                });
            });

            $('#payment_month').on('change', function() {
                var month = $('#payment_month').val();
                $('#description').val('Payment of month : ' + month + '. Bill Month : ' + month);
            });

            $('#paymentSearch').on('click', function(e) {
                $("#loader").show();
                e.preventDefault();
                $.ajax({
                    type: 'get',
                    url: '{{ route('billPaymentReportSearch') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                        $("#loader").hide();
                    }
                });
            });
        });
    </script>
@endsection
