@extends('layout.app')

@section('content')
    <div class="container-fluid ">
        <div class="container-fluid">

            <div class="row">
                <div class="col-md-2">
                    <ul class="nav nav-tabs w-100 d-flex flex-column justify-content-between align-items-start rounded"
                        id="myTab" role="tablist"
                        style=" padding:8px;box-shadow: 0 1px 3px 0 rgb(0 0 0 / 0.1), 0 1px 2px -1px rgb(0 0 0 / 0.1); --tw-shadow-color: #1f2937;">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link tab-text active" id="service-tab" data-toggle="tab"
                                data-target="#service" type="button" role="tab" aria-controls="service"
                                aria-selected="true">
                                Service Information <i class="fa-solid fa-info btn btn-info"></i></button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link tab-text" id="basic-tab" data-toggle="tab" data-target="#basic"
                                type="button" role="tab" aria-controls="basic" aria-selected="false">Basic Information
                                <i class="fa-regular fa-user  btn btn-info"></i></button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link tab-text" id="address-tab" data-toggle="tab" data-target="#address"
                                type="button" role="tab" aria-controls="address" aria-selected="false">Address<i
                                    class="fa-regular fa-map btn btn-info"></i>
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link tab-text" id="building-tab" data-toggle="tab" data-target="#building"
                                type="button" role="tab" aria-controls="building" aria-selected="false">Building Owner
                                Contact
                                <i class="fa-solid fa-house btn btn-info"></i></button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link tab-text" id="connection-tab" data-toggle="tab"
                                data-target="#connection" type="button" role="tab" aria-controls="connection"
                                aria-selected="false">Connection
                                Information
                                <i class="fa-solid fa-ethernet btn btn-info"></i>
                            </button>
                        </li>
                    </ul>
                </div>
                <div class="col-md-10" style="border-right: 4px;">
                    <form action="#" method="POST" style="overflow-y: auto; height:800px;">
                        @csrf

                        <x-addCustomer.service-info></x-addCustomer.service-info>

                        <x-addCustomer.basic-info></x-addCustomer.basic-info>

                        <x-addCustomer.address></x-addCustomer.address>

                        <x-addCustomer.buildingOwner></x-addCustomer.buildingOwner>

                        <x-addCustomer.connection></x-addCustomer.connection>

                    </form>
                </div>
            </div>

        </div>
    </div>
@endsection


<script>
    document.addEventListener('DOMContentLoaded', () => {
        const buttons = document.querySelectorAll('[id*="-tab"]');
        console.log(buttons);
        buttons.forEach(button => {
            button.addEventListener('click', () => {
                console.log('Button clicked:', button.id);
            });
        });
    });
</script>

<style>
    body {
        padding: 10px;

    }

    #exTab1 .tab-content {
        color: white;
        background-color: #428bca;
        padding: 5px 15px;
    }

    #exTab2 h3 {
        color: white;
        background-color: #428bca;
        padding: 5px 15px;
    }

    /* remove border radius for the tab */

    #exTab1 .nav-pills>li>a {
        border-radius: 0;
    }

    /* change border radius for the tab , apply corners on top*/

    #exTab3 .nav-pills>li>a {
        border-radius: 4px 4px 0 0;
    }

    #exTab3 .tab-content {
        color: white;
        background-color: #40464b;
        padding: 5px 15px;
    }

    .tab-text {
        letter-spacing: 0.025em;

    }
</style>
