@extends('layout.app')


@section('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{ asset('admin/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
@endsection

@section('content')
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title" style="color:#115548;">Expense List</h3>
                            <div class="card-tools">

                                {{-- <a href="{{ route('expense-head.index') }}"><button class="btn btn-sm btn-primary"><i
                                            class="fa fa-list" aria-hidden="true"></i> &nbsp;Expense Head List</button></a> --}}

                                <a href="{{ route('expense-head.create') }}"><button class="btn btn-sm btn-primary"><i
                                            class="fa fa-plus-circle" aria-hidden="true"></i> &nbsp; Expense
                                        Type</button></a>


                                <button data-toggle="modal" data-target="#expenseAdd" class="btn btn-sm btn-primary"><i
                                        class="fa fa-plus-circle" aria-hidden="true"></i> &nbsp; Expense</button>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="dataTable" class="display">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Status</th>
                                            {{-- <th>Income Head</th> --}}
                                            <th>Name</th>
                                            <th>Expense Head</th>
                                            <th>Employee</th>
                                            <th>Invoice Number</th>
                                            <th>Date</th>
                                            <th>Amount</th>
                                            <th>Documents</th>
                                            <th>Description</th>
                                            <th>Create By</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($expenses as $row)
                                            <tr>
                                                <td>{{ $row->id }}</td>
                                                <td>
                                                    @if ($row->status == 'pending')
                                                        <span class="badge badge-danger">Pending</span>
                                                    @elseif($row->status == 'approved')
                                                        <span class="badge badge-success">Approved</span>
                                                    @endif
                                                </td>
                                                <td>{{ $row->name }}</td>
                                                <td>{{ $row->head->name ?? '' }}</td>
                                                <td>{{ $row->employee->name ?? '' }}</td>
                                                <td>{{ $row->invoice_number }}</td>
                                                <td>{{ date('d/m/Y', strtotime($row->date)) }}</td>
                                                <td>{{ $row->amount }}</td>
                                                <td>
                                                    @if (!empty($row->attach_document))
                                                        {{-- <a href="{{ url('addIncomeDocument/' . $row->attach_document) }}"
                                                        download="download" target="_blank">
                                                        <i class="fa fa-download" style="margin-inline: 40px"
                                                            aria-hidden="true"></i>
                                                    </a> --}}
                                                        <img src="{{ asset('storage/expenseDocument/' . $row->attach_document) }}"
                                                            style="width: 100px; height:100px;">
                                                    @else
                                                        <p style="margin-inline: 10px">No File </p>
                                                    @endif
                                                </td>
                                                <td>{{ $row->description }}</td>
                                                <td>{{ $row->admin->name ?? '' }}</td>
                                                <td>
                                                    <div class="dropdown">
                                                        <button class="btn btn-primary dropdown-toggle" type="button"
                                                            id="dropdownMenuButton" data-toggle="dropdown"
                                                            aria-haspopup="true" aria-expanded="false">
                                                            Action
                                                        </button>
                                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">

                                                            @can('expense-section')
                                                                @if (!in_array($row->head->id, [6]))
                                                                    @if ($row->status != 'approved')
                                                                    @can('expense-approve')

                                                                        <form action="{{ route('expense-approve', $row) }}"
                                                                            method="POST">
                                                                            @csrf
                                                                            @method('post')
                                                                            <button id="{{ $row->id }}"
                                                                                onclick="return confirm('Are you sure you want to Approve?');"
                                                                                class="dropdown-item">Approve</button>
                                                                        </form>
                                                                    @endcan

                                                                        <a href="{{ route('expense.edit', $row->id) }}"
                                                                            class="dropdown-item">
                                                                            <i class="fa fa-pencil-square-o"></i>
                                                                            Edit
                                                                        </a>
                                                                        <a href="{{ route('editLog-history', ['id' => $row->id, 'type' => 'Expense']) }}"
                                                                            class="dropdown-item">
                                                                            <i class="fa fa-pencil-square-o"></i>History
                                                                        </a>
                                                                        <form action="{{ route('expense.destroy', $row) }}"
                                                                            method="POST">
                                                                            @csrf
                                                                            @method('DELETE')
                                                                            <button id="{{ $row->id }}"
                                                                                onclick="return confirm('Are you sure you want to Delete?');"
                                                                                class="dropdown-item">Delete</button>
                                                                        </form>
                                                                    @else
                                                                        <span class="dropdown-item">No Action available</span>
                                                                    @endif
                                                                @endif
                                                            @endcan
                                                        </div>
                                                    </div>


                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->



                    <div class="modal fade" id="expenseAdd" role="dialog" aria-labelledby="exampleModalCenterTitle"
                        aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">Add Expense</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <form method="POST" action="{{ route('expense.store') }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="modal-body">


                                        <div class="card-body">

                                            <div class="row">

                                                <div class="col-md-12">
                                                    <label for="shortname">
                                                        Expense Title*
                                                    </label>
                                                    <input type="text" name="name" class="form-control"
                                                        placeholder="Enter Name" required>
                                                </div>

                                                <div class="col-md-12">
                                                    <label for="shortname">
                                                        Expense Head*
                                                    </label>
                                                    <select name="expenseHead" id="expense_head"
                                                        class="form-control select2" required>
                                                        <option value="">Select One</option>
                                                        @foreach ($expenseHead as $item)
                                                            <option value="{{ $item->id }}">{{ $item->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="col-md-12" style="display: none" id="employee_block">
                                                    <label for="employee">Select Employee</label>
                                                    <select name="employee" id="employee" class="form-control">
                                                        <option value="">Select Employee</option>
                                                        @foreach (getEmployesInExpense() as $employee)
                                                            <option value="{{ $employee->id }}">{{ $employee->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="col-md-12" id="invoice">
                                                    <label for="shortname">
                                                        Invoice Number
                                                    </label>
                                                    <input type="text" name="invoice_number" class="form-control"
                                                        placeholder="Enter Invoice Number">
                                                </div>
                                                <div class="col-md-12">

                                                    <label for="shortname">
                                                        Date*
                                                    </label>


                                                    <div class="input-group date" id="searchFrom"
                                                        data-target-input="nearest">
                                                        <input type="text" name="date"
                                                            class="form-control datetimepicker-input input-group-append"
                                                            data-toggle="datetimepicker" data-target="#searchFrom"
                                                            autocomplete="off">
                                                    </div>



                                                    {{--
                                                    <input type="date" name="date" class="form-control "
                                                        placeholder="Enter Date" required> --}}
                                                </div>
                                                {{-- <div class="col-md-12">
                                            <label for="shortname">
                                                Date*
                                            </label>
                                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                                <input type="text" name="date"
                                                    class="form-control datetimepicker-input input-group-append"
                                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                                            </div>
                                        </div> --}}
                                                <div class="col-md-12">
                                                    <label for="shortname">
                                                        Amount*
                                                    </label>
                                                    <input type="number" name="amount" class="form-control"
                                                        placeholder="Enter Amount" required>
                                                </div>
                                                <div class="col-md-12 mt-2">
                                                    <label for="shortname">Attach Document</label>
                                                    <input type="file" name="attach_document">
                                                </div>
                                                <div class="col-md-12">
                                                    <label for="shortname">
                                                        Description
                                                    </label>
                                                    <textarea name="description" class="form-control" placeholder="Type Description"></textarea>
                                                </div>

                                            </div>
                                        </div>


                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary"
                                            data-dismiss="modal">Close</button>
                                        <button type="submit" class="btn btn-primary">Add Expense</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
            <!-- /.row -->

        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
@endsection
@section('ajax')
    <script>
        $(function() {

            $('#expense_head').on('change', function() {
                let type = $('#expense_head').val();
                console.log(type);
                // if (type == 1) {
                    $('#employee_block').show();
                    // $('#invoice').hide();
                // } else {
                    // $("#employee option:selected").prop("selected", false)
                    // $('#employee_block').hide();
                    $('#invoice').show();
                // }
            });


            $("#example1").DataTable({
                "responsive": true,
                "autoWidth": false,
            });
            $('#example2').DataTable({
                "paging": true,
                "lengthChange": false,
                "searching": false,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "responsive": true,
            });


        });
    </script>
    <!-- DataTables -->
    {{-- <script src="{{ asset('admin/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('admin/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('admin/plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('admin/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/vue@2.6.14/dist/vue.js"></script> --}}
@endsection
