<?php

namespace App\Jobs;

use App\Services\ClientActiveService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class MakeClientActiveJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    private $id;
    private $details;
    private $authUserId;
    public function __construct($id, $details, $authUserId)
    {
        $this->id = $id;
        $this->details = $details;
        $this->authUserId = $authUserId;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        (new ClientActiveService)->active($this->id, $this->details, $this->authUserId);
    }
}
