@extends('layout.app')


@section('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{ asset('admin/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
@endsection

@section('content')

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title" style="color:#115548;">Income Head List</h3>
                            <div class="card-tools">

                                <a href="{{ route('income.index') }}"><button class="btn btn-sm btn-info"><i
                                    class="fa fa-arrow-left" aria-hidden="true"></i> &nbsp;Income
                                List</button></a>

                                <a href="{{ route('income-head.create') }}"><button class="btn btn-sm btn-primary"><i
                                            class="fa fa-plus-circle" aria-hidden="true"></i> &nbsp; Income
                                        Head</button></a>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="dataTable" class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Income Head</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($incomeheads as $row)
                                        <tr>
                                            <td>{{ $row->id }}</td>
                                            {{-- <td>{{ $row->incomeHead}}</td> --}}
                                            <td>{{ $row->name }}</td>
                                            <td>
                                                @can('income-section')
                                                @if(!in_array($row->id,[1,2,3,4,5,6,11]))
                                                    <div class="btn-group">
                                                        <a href="{{ route('income-head.edit', $row->id) }}"
                                                            class="btn btn-sm btn-primary">
                                                            <i class="fa fa-pencil-square-o"></i>
                                                            Edit
                                                        </a>
                                                    </div>

                                                    {{-- <div class="btn-group">
                                                        <form action="{{ route('income-head.destroy', $row) }}" method="POST">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button id="{{ $row->id }}"
                                                                class="btn btn-sm btn-danger">Delete</button>
                                                        </form>
                                                    </div> --}}
                                                    @endif
                                                @endcan
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->

                </div>
            </div>
            <!-- /.row -->

        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
@endsection
@section('js')
    <!-- DataTables -->
    <script src="{{ asset('admin/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('admin/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('admin/plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('admin/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
@endsection
@push('script')
    <!-- page script -->
    <script>
        $(function() {
            $("#example1").DataTable({
                "responsive": true,
                "autoWidth": false,
            });
            $('#example2').DataTable({
                "paging": true,
                "lengthChange": false,
                "searching": false,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "responsive": true,
            });
        });
    </script>
@endpush
