@php($permissions = userPermissions())
<div class="table-responsive" id="result" style="min-height:500px;">

    <input type="hidden" id="DaywiseRecharge" name="DaywiseRecharge"
        value="{{ checkSettings('recharge_expire_customer_today') }}">
    @if (request()->path() == 'admin/list/new-join' || request()->path() == 'admin/newClientSearchReport')
        <div class="float-right">Total : {{ $list->total() }}</div>
        @if ($export == 'yes')
            <a class="noprint btn btn-primary m-1" href="{{ route('recentClientExport') }}"><i class="fa fa-print"></i>
                Download CSV</a>
        @endif
    @endif

    @if (request()->path() == 'admin/list/close-list')
        <a class="noprint btn btn-primary" href="{{ route('closeClientExport') }}"><i class="fa fa-print"></i>
            Export</a>
        <div class="float-right">Total Closed: {{ $closeTotal ?? 0 }}</div>
    @endif
    @if (request()->path() == 'admin/close-search-list')
        <a class="noprint btn btn-primary mt-1 mb-1" href="{{ route('closeClientListExport') }}"><i
                class="fa fa-print"></i> Download CSV</a>
    @endif

    @if (request()->path() == 'admin/list/expired-Clients' || request()->path() == 'admin/expire-customer-search')
        <div class="mb-2">
            @if (request()->path() == 'admin/expire-customer-search')
                <a class="noprint btn btn-primary m-1" href="{{ route('expireClientExport') }}"><i class="fa fa-print"></i>
                    Download CSV</a>
            {{-- @else
                <button class="btn btn-primary" onclick="export2csv()">Download csv</button> --}}
            @endif
        </div>
    @endif

    @if (request()->path() == 'admin/free-cleint' || request()->path() == 'admin/freeClientSearch')
        <h5>Total Free Client: {{ $list->count() }}</h5>
    @endif
    <div class="scrollbar">
        @if (request()->path() == 'admin/pending-customer' || request()->path() == 'admin/pending-customer-search')
            <div>
                @if (checkSettings('local-user-first-approve') == 'enable')
                    @if (in_array('local-user-first-approve', $permissions))
                        <button class="btn btn-primary m-2" id="firstAllApprove"><i class="fa fa-check"></i>Final
                            Approve</button>
                    @elseif (in_array('new-customer-approve', $permissions))
                        <button class="btn btn-success float-right m-2" id="allApprove"><i class="fa fa-check"></i>
                            Approve</button>
                    @endif
                @else
                    @if (in_array('new-customer-approve', $permissions))
                        <button class="btn btn-success float-right m-2" id="allApprove"><i class="fa fa-check"></i>
                            Approve</button>
                    @endif
                @endif
            </div>
        @endif

        @if (checkSettings('all-client-dataTable') == 'enable' && request()->path() == 'admin/clients')
            <table id="dataTable" class="display" data-paging='false'>
                <style>
                    .dataTables_filter,
                    .dataTables_info {
                        display: none;
                    }
                </style>
            @elseif (request()->path() == 'admin/expire-customer-search' ||
                    request()->path() == 'admin/getResellerPopList' ||
                    request()->path() == 'admin/online-customer-search' ||
                    request()->path() == 'admin/list/new-join' ||
                    request()->path() == 'admin/newClientSearchReport' ||
                    request()->path() == 'admin/disable-customer-search' ||
                    request()->path() == 'admin/deactive-customer' ||
                    request()->path() == 'admin/active-customer' ||
                    request()->path() == 'admin/free-client' ||
                    request()->path() == 'admin/freeClientSearch')
                <table class="table table-bordered table-striped table-condensed table_dowanload product-table mt-3"
                    id="dataTable">
                @else
                    <table class="table table-bordered table-striped table-condensed table_dowanload product-table mt-3"
                        @if (isset($close)) id="dataTable" @endif>
        @endif

        <thead>
            <tr style="background:#78716C !important; color:white;">
                @if (request()->path() == 'admin/clientSearchReport')
            <tr>
                <td colspan="15">
                    <p class="text-center">{{ $status }}</p>
                    <p class="text-center">
                        {!! $packages_count !!}
                    </p>
                    <p class="text-center">
                        {!! $billing_count !!}
                    </p>
                </td>
            </tr>
            @endif
            @if (request()->path() == 'admin/pending-customer' ||
                    request()->path() == 'admin/clientSearchReport' ||
                    request()->path() == 'admin/pending-customer-search')
                <th class="text-center">
                    <input type="checkbox" id="allSelect">
                </th>
            @endif
            <th>ID</th>
            <th style="width: 180px !important;">User name</th>
            <th>Status</th>
            <th>Expire</th>
            <th>Bill Info</th>
            <th>Package</th>
            <th>POP</th>
            <th>Name</th>
            <th>Contact</th>
            <th style="width:350px">User Info</th>
            <th>Date</th>
            @if (request()->path() == 'admin/list/close-list' || request()->path() == 'admin/close-search-list')
                <th>Close Date</th>
            @endif
            <th>Remarks</th>
            @if (request()->path() == 'admin/pending-customer')
                <th>Created By</th>
            @endif

            </tr>
        </thead>
        @if (auth()->user()->hasRole(['Sub Reseller']))
            <input type="hidden" id="checkSubReseller" value="Sub-Reseller">
        @endif
        <tbody>
            @php($catTotalLength = 0)
            @php($totalOtc = 0)
            @php($totalMrc = 0)
            @php($apiCheck = checkAPI())




            @if (request()->path() == 'admin/list/disable-customer' ||
                    request()->path() == 'admin/list/expired-Clients' ||
                    request()->path() == 'admin/pending-customer')
                <h4>Total = {{ $list->total() }}</h4>
            @endif
            @if (request()->path() == 'admin/disable-customer-search' ||
                    request()->path() == 'admin/expire-customer-search' ||
                    request()->path() == 'admin/pending-customer-search' ||
                    request()->path() == 'admin/active-customer-search' ||
                    request()->path() == 'admin/close-search-list')
                <h4>Total = {{ $list->count() }}</h4>
            @endif


            @foreach ($list as $r)
                {{-- {{ dd($r)}} --}}


                <tr @if ($r->clients_status == 'deactive') class="deactive" @endif>
                    @if (request()->path() == 'admin/clientSearchReport')
                        <td class="text-center">
                            @if (in_array('customer-recharge', $permissions))
                                @if ($r->pops->bill_generate != 'yes')
                                    <input type="checkbox" value="{{ $r->id }}"
                                        class="checkbox checkboxR checkboxprice" id="row_id" name="ids[]">
                                    @if (auth()->user()->hasRole(['Reseller Admin', 'Admin', 'Accounts Executive', 'Reseller']))
                                        <input type="hidden" name="price[]" class="current_price"
                                            value="{{ $r->packages->package_rate ?? 0 }}">
                                    @elseif(auth()->user()->hasRole(['Sub Reseller']))
                                        <input type="hidden" name="price[]" class="current_price"
                                            value="{{ $r->subpack->rate ?? 0 }}">
                                    @endif
                                    <input type="hidden" name="ep_date" class="ep_date"
                                        value={{ date('Y-M-d', strtotime($r->expire_date)) }}>
                                    <input type="hidden" name="billing_cycle" class="billing_cycle"
                                        value={{ $r->billing_cycle }}>
                                    <input type="hidden" class="reseller_price"
                                        value="{{ $r->packages->package_rate ?? 0 }}">
                                    <input type="hidden" class="subreseller_price"
                                        value="{{ $r->subpack->rate ?? 0 }}">
                                @else
                                    <input type="checkbox" value="{{ $r->id }}"
                                        class="checkbox checkboxR checkboxprice" id="row_id" name="ids[]">
                                @endif
                            @endif

                        </td>
                    @elseif(request()->path() == 'admin/pending-customer' || request()->path() == 'admin/pending-customer-search')
                        <td>
                            <input type="checkbox" class="checkbox new_class_for_client_id_of_pending" name="id[]"
                                value="{{ $r->id }}">
                        </td>
                    @endif


                    <td class="text-center">


                        @if ($r->pop->bill_generate == 'yes' )
                            @if (!globalPermission('payment-bill-by-bill'))

                                <button data-package_rate="{{ $r->packages->package_rate ?? 0 }}"
                                    data-billing_type = "{{ getBillingType() }}" data-id="{{ $r->id }}" data-userid="{{ $r->userid }}"
                                    @if ($r->customerAccount != null) data-amount="{{ $r->customerAccount->dueAmount > 0 ? $r->customerAccount->dueAmount : 0 }}" @endif
                                    type="button" class="btn btn-danger ajaxPayment btn-xs btn-block text-nowrap"
                                    data-toggle="modal" data-target="#paymentModal">
                                    Payment
                                </button>
                            @endif

                            <a class=" btn-info btn-block btn-xs text-nowrap clear"
                                href="{{ route('getPaymentHistory', $r->id) }}">CID: {{ $r->id }}</a>
                        @else
                            @if (in_array('customer-recharge', $permissions))
                                @if (checkSettings('reseller-client-dynamic-recharge') == 'enable' && in_array('dynamic-recharge', $permissions))
                                @else
                                    @if ($r->client_approval == 'approved')
                                        <button data-id="{{ $r->id }}" type="button"
                                            class="btn btn-dark ajaxRecharge btn-xs btn-block text-nowrap">
                                            Rechage
                                        </button>
                                    @endif
                                @endif
                            @endif
                            @if (globalPermission('reseller-client-billing') && in_array('view-client-account-balance', $permissions))
                                <a class=" btn-info btn-block btn-xs text-nowrap clear" href="{{ route('getPaymentHistoryOfResellerClient', $r->id) }}">CID: {{ $r->id }}</a>
                            @else
                                <span class=" btn-info btn-block btn-xs text-nowrap">CID {{ $r->id }}</span>

                            @endif

                        @endif

                        @if (!checkAPI() || checkSettings('api_bandwidth_usage') == 'enable')
                            <a href="{{ route('getCustomerLogHistory', $r->id) }}"
                                class="noprint btn btn-primary btn-xs btn-block">Log</a>
                        @endif
                        @if ($r->deleted_at != null)
                            <a href="{{ route('close-customer-details', $r->id) }}"
                                class="noprint btn btn-primary btn-xs btn-block">Details</a>
                        @else
                            <a href="{{ route('clients.show', $r->id) }}"
                                class="noprint btn btn-primary btn-xs btn-block">Details</a>
                        @endif

                        @if (checkSettings('singleInvoice') == 'enable' && $r->pop->bill_generate == 'yes')
                            <button data-id="{{ $r->id }}"
                                class="btn btn-info btn-xs text-nowrap btn-block viewInvoice">View Invoice</button>

                            <button data-id="{{ $r->id }}"
                                class="btn btn-danger btn-sm btn-block sendInvoice"><i class="fa fa-envelope"></i>
                                Send</button>
                        @endif
                        <div class="mt-2">
                            @if ($r->deleted_at != null)
                                <div class="dropdown">
                                    <button class="btn btn-primary btn-sm btn-block dropdown-toggle" type="button"
                                        id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                        aria-expanded="false">
                                        Action
                                    </button>
                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">

                                        <a href="{{ route('close-customer-details', $r->id) }}"
                                            class="dropdown-item">Details</a>

                                        @if (in_array('delete_customer_edit', $permissions))
                                            <a href="{{ route('clients.edit', $r->id) }}"
                                                class="dropdown-item">Edit</a>
                                        @endif

                                        @if (in_array('mac-customer_destroy', $permissions) && $r->pops->bill_generate != 'yes')
                                            <button class="dropdown-item idDestroy"
                                                data-id="{{ $r->id }}">Delete</button>
                                        @endif

                                        <div class="mb-1"></div>

                                        @if (in_array('can-open', $permissions))
                                            <a href="{{ route('open', $r->id) }}"
                                                onclick="return confirm('Are you sure you want to Open the ID?');"
                                                class="confirmDisable dropdown-item bg-danger">Restore Account</a>
                                        @endif


                                    </div>
                                </div>
                            @else
                                <div class="dropdown">



                                    <button class="btn btn-primary btn-sm btn-block dropdown-toggle" type="button"
                                        id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                        aria-expanded="false">
                                        Action
                                    </button>
                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">

                                        {{-- @can('add-otc') --}}
                                        @if (in_array('add-otc', $permissions))
                                            @if ($r->pops->bill_generate == 'yes')
                                                @if ($r->clientsinfo->otc < 1)
                                                    <button type="button" class="dropdown-item addOtc"
                                                        data-toggle="modal" data-id="{{ $r->id }}"
                                                        data-target="#addOtc">
                                                        Add Otc
                                                    </button>
                                                @endif
                                            @endif
                                        @endif
                                        @if ($r->pop->bill_generate == 'yes')
                                            @php($link = App\Http\Controllers\CompanyInfoController::baseUrl() . $r->slug)

                                            <p id="client-{{ $r->id }}" class="d-none">{{ $link }}
                                            </p>
                                            <a href="#" class="dropdown-item"
                                                onclick="copyToClipboard({{ $r->id }})">Copy Payment URL</a>

                                            <a href="{{ route('clientQrcode', $r->id) }}" class="dropdown-item"
                                                target="_blank">Print QR Code</a>
                                        @endif
                                        <a href="{{ route('clients.show', $r->id) }}"
                                            class="dropdown-item">Details</a>

                                        {{-- @can('mac-customer_edit') --}}
                                        @if (in_array('mac-customer_edit', $permissions))
                                            <a href="{{ route('clients.edit', $r->id) }}"
                                                class="dropdown-item">Edit</a>
                                        @endif


                                        @if ($r->is_free == 0)
                                            @if (request()->path() == 'admin/clients' ||
                                                    request()->path() == 'admin/customer_search' ||
                                                    request()->path() == 'admin/clientSearchReport')
                                                @if (in_array('changeBillCycle', $permissions))
                                                    <button type="button" class="dropdown-item clientBillCycleChange"
                                                        data-toggle="modal" data-id="{{ $r->id }}"
                                                        data-curdate={{ $r->billing_cycle }}
                                                        data-target="#billCycleChange">
                                                        Bill Cycle Change
                                                    </button>
                                                @endif
                                            @endif
                                        @endif
                                        @if (in_array('mac-customer_edit', $permissions))
                                            @if ($r->pop->bill_generate == 'yes' && auth()->user()->can('extend-temporary-dedline'))
                                                <button type="button" class="dropdown-item changeTemporaryExtend"
                                                    data-toggle="modal" data-id="{{ $r->id }}" data-tmpExtend={{ $r->payment_dadeline }}
                                                    data-target="#expDateExtend">Expire Date Extend
                                                </button>
                                            @endif
                                        @endif
                                        @if (request()->path() == 'admin/clients' ||
                                                request()->path() == 'admin/customer_search' ||
                                                request()->path() == 'admin/clientSearchReport')
                                            @if (in_array('change_auto_deactive_date', $permissions))
                                                <button onclick="autoDeactiveDateApply({{ $r->id }})"
                                                    type="button" class="dropdown-item autoDeactiveDateChange"
                                                    data-toggle="modal" data-id="{{ $r->id }}"
                                                    data-autoDeactive="{{ date('d-M-Y', strtotime($r->auto_deactive)) }}"
                                                    data-target="#deactiveDateChange"
                                                    id="autoDeactiveId-{{ $r->id }}">
                                                    Auto Deactive Date
                                                </button>
                                            @endif
                                        @endif

                                        @if ($r->is_free == 0)
                                            @if (request()->path() == 'admin/clients' ||
                                                    request()->path() == 'admin/customer_search' ||
                                                    request()->path() == 'admin/clientSearchReport')
                                                @if (in_array('changePackage', $permissions))
                                                    <a href="" type="button"
                                                        data-clientid="{{ $r->id }}"
                                                        class="package_change_action_btn dropdown-item"
                                                        data-toggle="modal"
                                                        data-target="#package_change_modal">Package
                                                        Change</a>
                                                @endif
                                            @endif
                                        @endif




                                        @if (checkSettings('schedule_package') == 'enable' && in_array('schedule-package-change', $permissions))
                                            <a href="" type="button" data-clientid="{{ $r->id }}"
                                                class="schedule_package_change dropdown-item" data-toggle="modal"
                                                data-target="#schedule_package_change_modal">Schedule Package
                                                Change</a>
                                        @endif




                                        <div class="mb-1"></div>


                                        @if ($r->clients_status == 'disable')
                                            @if (in_array('id-enable', $permissions))
                                                <a href="#" data-id="{{ $r->id }}"
                                                    id="{{ $r->id }}"
                                                    class="idEnable dropdown-item">Enable</a>
                                            @endif
                                        @endif


                                        @if ($r->clients_status != 'disable')
                                            @if (in_array('id-disable', $permissions))
                                                <a href="#" data-id="{{ $r->id }}"
                                                    id="{{ $r->id }}"
                                                    class=" idDisable confirmDisable dropdown-item ">Disable </a>
                                            @endif
                                        @endif


                                        @if ($r->clients_status != 'deactive')
                                            @if (in_array('customer-deactivated', $permissions))
                                                <a href="#" data-id="{{ $r->id }}"
                                                    id="deactive{{ $r->id }}"
                                                    class="id_deactive  dropdown-item">Deactive
                                                </a>
                                            @endif
                                        @endif
                                        @if ($r->clients_status == 'deactive')
                                            @if (in_array('customer-reactivate', $permissions))
                                                <a href="#" data-id="{{ $r->id }}"
                                                    id="reactive{{ $r->id }}"
                                                    class="id_reactive   dropdown-item">Reactive
                                                </a>
                                            @endif
                                        @endif
                                        @if (in_array('can-close', $permissions))
                                            @if (request()->path() != 'admin/pending-customer')
                                                @if ($r->deleted_at == null)
                                                    <a href="#" data-id="{{ $r->id }}"
                                                        class="idClose dropdown-item">Close</a>
                                                @else
                                                @endif
                                            @endif
                                        @endif

                                        @if ($r->pops->bill_generate != 'yes' || $r->client_approval == "pending")
                                            @if (in_array('mac-customer_destroy', $permissions))
                                                <button class="dropdown-item idDestroy"
                                                    data-id="{{ $r->id }}">Delete</button>
                                            @endif
                                        @endif



                                        @if ($r->ignoreMKCheck == 0)
                                            <form method="POST" action="{{ route('reSyncSingleClient') }}">
                                                @csrf
                                                <input type="hidden" name="id" value="{{ $r->id }}">
                                                <button
                                                    onclick="return confirm('Are you sure you want to re-sync this user ?');"
                                                    type="submit" class="dropdown-item">Re-Sync</button>
                                            </form>
                                        @else
                                            <button type="button" class="dropdown-item" disabled>Ignore MK :
                                                &#x2705;</button>
                                        @endif

                                        @if ($r->isStatic && Auth::user()->can('static_manage'))
                                            {!! Form::open(['method' => 'DELETE', 'route' => ['remove-buinding-static', $r->id]]) !!}
                                            <button type="submit" class="dropdown-item">Remove Mac Bind</button>
                                            {!! Form::close() !!}
                                        @endif
                                        @can('never_disconnect')
                                            <form method="POST" action="{{ route('neverDisconnectClient') }}">
                                                @csrf
                                                <input type="hidden" name="id" value="{{ $r->id }}">

                                                @if($r->experity_check == "Yes")
                                                    <input type="hidden" name="experity_check" value="No">
                                                    <button onclick="return confirm('Are you sure to never disconnect this user?');"
                                                        type="submit" class="dropdown-item">Never Disconnect</button>
                                                @else
                                                    <input type="hidden" name="experity_check" value="Yes">
                                                    <button onclick="return confirm('Are you sure to Check regular process?');"
                                                        type="submit" class="dropdown-item">Check Expired</button>
                                                @endif

                                            </form>
                                        @endcan
                                        <button class="dropdown-item"><a
                                                href="{{ route('printClientCopy', $r->id) }}"
                                                target="_blank">Print</a></button>

                                    </div>
                                </div>
                            @endif
                        </div>

                    </td>
                    <td class="no-wrap ">
                        <div class="d-flex justify-content-between">


                            <div>
                                <i class="fa-solid fa-user bg-success text-light p-1 rounded-circle"
                                    aria-hidden="true" style="font-size: 0.75rem;"></i>

                                {{ $r->isStatic ? $r->ip_address : $r->userid }}



                                @if (in_array('view-client-password', $permissions))
                                    @if (!$r->isStatic)
                                        <br>
                                        <div style="margin-top: 5px !important">

                                        </div>
                                        <i class="fa fa-key bg-danger text-light p-1 rounded-circle"
                                            aria-hidden="true" style="font-size: 0.75rem;"></i>
                                        {{ $r->password }}
                                        <br>
                                    @endif
                                @endif

                                @if (checkSettings('customer_code') == 'enable')
                                    <i class="fa-solid fa-user-secret bg-warning text-light p-1 rounded-circle"></i>
                                    {{ $r->customer_code ?? '' }}
                                @endif

                                @if ($r->is_free == 1)
                                    <p class="badge badge-info m-0">Free</p>
                                @endif


                                @if (request()->path() == 'admin/clientSearchReport' && checkAPI())
                                    <div class="d-flex justify-content-start">
                                        <a role="button" id="clientOnlineButton-{{ $r->id }}"
                                            data-client-id="{{ $r->id }}" style="cursor:pointer; ">
                                            <i class="fa-regular fa-eye bg-success text-light p-1 rounded-circle"
                                                style="font-size: 0.75rem; "></i>
                                        </a>
                                        <p class="response-paragraph"></p>
                                    </div>
                                @endif

                                @if (request()->path() == 'admin/list/close-list' ||
                                        (request()->path() == 'admin/close-search-list' && $r->deleted_at != null))
                                    <span class="btn btn-danger btn-xs">
                                        Closed at <br>
                                        {{ $r->deleted_at }}
                                    </span>
                                @endif

                                @if (request()->path() == 'admin/list/disable-customer' || request()->path() == 'admin/disable-customer-search')
                                    @foreach ($con_history as $con)
                                        @isset($con->client_id)
                                            @if ($r->id == $con->client_id)
                                                <span class="btn btn-sm bg-danger ">
                                                    {{ $con->created_at }}
                                                </span>
                                            @endif
                                        @endisset
                                    @endforeach
                                @endif


                                @if (request()->path() == 'admin/clients' || request()->path() == 'admin/customer_search')
                                    <br>
                                    @if (checkAPI())
                                        @if (!$r->isStatic)
                                            @if (array_key_exists($r->userid, $online['onlineUsers']))
                                                @can('router-remote-access')
                                                {{-- <iframe src="https://10.151.125.2:443" onload="console.log('Loaded')" onerror="toastr.error('Cannot load')"></iframe> --}}
                                                    <a href="http://{{ $online['onlineUsers'][$r->userid]['address'] ?? '' }}:{{ siteinfo()->remote_router_port ?? '' }}" class="" target="_blank">
                                                        <i class="fa fa-sign-out bg-info text-light p-1 rounded-circle" aria-hidden="true" style="font-size: 0.75rem;"></i>
                                                    </a>
                                                @endcan

                                                <span class="btn-success btn-xs">
                                                    @if (globalPermission('online-offline-using-api'))
                                                        Online
                                                    @else
                                                        {{ $online['onlineUsers'][$r->userid]['address'] ?? '' }}
                                                    @endif
                                                </span>
                                            @else
                                                @if (isset($online['allUsers'][$r->userid]['last-logged-out']))
                                                    @if (preg_match('/\b\d{4}\b/', $online['allUsers'][$r->userid]['last-logged-out'], $matches) == 1)
                                                        @if ($matches[0] != '1970')
                                                            <span class="btn btn-danger btn-xs">
                                                                @if (globalPermission('online-offline-using-api'))
                                                                    Offline
                                                                @else
                                                                    {{ parseDate($online['allUsers'][$r->userid]['last-logged-out']) }}
                                                                @endif
                                                            </span>
                                                        @else
                                                            <span class="btn-warning btn-xs p-1 text-light">
                                                                Never Connected
                                                            </span>
                                                        @endif
                                                    @endif
                                                @endif
                                            @endif
                                        @else
                                            @if (array_key_exists($r->ip_address, $online['ipArpListsGlobal']))
                                                <span
                                                    class="mt-1 btn @if ($online['ipArpListsGlobal'][$r->ip_address]['disabled'] == 'false') btn-success @else btn-danger @endif btn-xs">
                                                    @if ($online['ipArpListsGlobal'][$r->ip_address]['disabled'] == 'false')
                                                        Online
                                                    @else
                                                        ARP-Disabled
                                                    @endif
                                                </span>
                                            @endif
                                        @endif


                                        @if (checkSettings('showClientUpDownInfo') == 'enable')
                                            @if (array_key_exists($r->userid, $online['usersBandwidth']))
                                                <span>
                                                    <strong>Download⬇️</strong>
                                                    {{ number_format($online['usersBandwidth'][$r->userid]['tx-byte'] / 1048576, 2, '.', '') }}MB
                                                </span>
                                                <span>

                                                    <strong>Upload⬆️</strong>
                                                    {{ number_format($online['usersBandwidth'][$r->userid]['rx-byte'] / 1048576, 2, '.', '') }}MB
                                                </span>
                                            @endif
                                        @endif
                                    @else
                                        @if (isset($online) && in_array($r->userid, $online))
                                            <span class="btn btn-success btn-xs">Online</span>
                                        @else
                                            <span class="btn btn-danger btn-xs">Offline</span>
                                        @endif
                                    @endif
                                    <br>
                                    @if ($r->ignoreMKCheck == 1)
                                        <p>Ignore MK : &#x2705;</p>
                                    @endif
                                @endif
                            </div>
                            <div>

                                @if (checkSettings('radius_customer_bandwidth_limit') == 'enable')
                                    <p>
                                        <span class="badge badge-warning">D⬇️ @if ($r->down_bandwidth >= 1024)
                                                {{ number_format($r->down_bandwidth / 1024, 2, '.', '') }}GB
                                            @else
                                                {{ $r->down_bandwidth }}MB
                                            @endif
                                        </span>
                                    </p>

                                    <p><span class="badge badge-warning">U⬆️ @if ($r->up_bandwidth >= 1024)
                                                {{ number_format($r->up_bandwidth / 1024, 2, '.', '') }}GB
                                            @else
                                                {{ $r->up_bandwidth }}MB
                                            @endif
                                        </span>
                                    </p>
                                @endif

                            </div>

                        </div>
                        @if($r->experity_check == "No")
                            <div class="mt-2">
                                <div class="" style="display: inline-block; border: 2px solid red; color: red; font-weight: bold;
                                    text-align: center; padding: 2px 5px; border-radius: 4px; font-size: 12px; ">VIP</div>
                            </div>
                        @endif
                    </td>

                    <td class="cStatus{{ $r->id }} {{ clientStatusClass($r->clients_status) }}">

                        @if ($r->clients_status == 'active')
                            Active
                        @elseif($r->clients_status == 'deactive')
                            Deactive</span>
                        @elseif($r->clients_status == 'expired')
                            Expired</span>
                        @elseif($r->clients_status == 'disable')
                            Disabled</span>
                        @endif

                    </td>
                    <td class="cExpireDate{{ $r->id }} @if ($r->payment_dadeline == 0) {{ clientStatusClass($r->clients_status) }} @endif"
                        style="min-width:140px;text-align:left; @if ($r->payment_dadeline != 0) background: #a8dadc; @endif ">
                        BD: <span
                            class="bdate_exp{{ $r->id }}">{{ date('d-M-Y', strtotime($r->expire_date)) }}</span><br>
                        @if ($r->payment_dadeline != 0)
                            <span class="d-block badge badge-warning">
                                PD:
                                {{ \Carbon\Carbon::parse($r->expire_date)->addDay($r->payment_dadeline)->format('d-M-Y') }}
                            </span>
                        @else
                            PD:
                            <span
                                class="bdate_exp{{ $r->id }}">{{ \Carbon\Carbon::parse($r->expire_date)->addDay($r->payment_dadeline)->format('d-M-Y') }}</span>
                        @endif

                        @can('change-expire-date')
                            <button type="button" class="dropdown-item changeExpireDate badge badge-dark p-1"
                                data-toggle="modal" data-id="{{ $r->id }}" data-target="#changeExpireDate">
                                Change
                            </button>
                        @endcan

                        @if (checkSettings('auto_deactive_check') == 'enable')
                            <br><br>
                            @if (!empty($r->auto_deactive))
                                AD: {{ date('d-M-Y', strtotime($r->auto_deactive ?? '')) }}
                            @endif
                        @endif
                    </td>


                    <td style="min-width:190px;" class="text-center">

                        <div class="w-100 text-start">
                            <p style="font-size:14px; text-align:start;">
                                Bill Date: {{ $r->billing_cycle }}

                                <br>
                                @if (isset($r->pops->bill_generate) && $r->pops->bill_generate == 'yes')
                                    Package Rate: @role('Sub Reseller')
                                        @if ($r->pops->subreseller == 'yes')
                                            {{ $r->subpack->rate ?? 0 }}
                                        @else
                                            {{ $r->packages->package_rate ?? 0 }}
                                        @endif
                                    @else
                                        {{ $r->packages->package_rate ?? 0 }}
                                    @endrole <br>
                                    Discount: {{ $r->parmanent_discount }} <br>
                                    Monthly Bill:
                                    @role('Sub Reseller')
                                        @if ($r->pops->subreseller == 'yes')
                                            {{ ($r->subpack->rate ?? 0) - ($r->parmanent_discount ?? 0) >= 0 ? ($r->subpack->rate ?? 0) - ($r->parmanent_discount ?? 0) : 0 }}
                                        @else
                                            {{ ($r->packages->package_rate ?? 0) - ($r->parmanent_discount ?? 0) >= 0 ? ($r->packages->package_rate ?? 0) - ($r->parmanent_discount ?? 0) : 0 }}
                                        @endif
                                    @else
                                        {{ ($r->packages->package_rate ?? 0) - ($r->parmanent_discount ?? 0) >= 0 ? ($r->packages->package_rate ?? 0) - ($r->parmanent_discount ?? 0) : 0 }}
                                    @endrole <br>
                                    OTC : {{ $r->clientsinfo->otc ?? 0 }} <br>
                                    @if (isset($r->clientsinfo->otc_due))
                                        @if ($r->clientsinfo->otc_due > 0)
                                            <span class="bg-danger pl-1 pr-1"> OTC Due:
                                                <span
                                                    class="listOtcDue{{ $r->id }}">{{ $r->clientsinfo->otc_due ?? 0 }}</span></span>
                                        @endif
                                    @endif
                                @else
                                    @if (globalPermission('ResellerClientOnlineRecharge'))
                                        Client Bill: {{ getResellerClientPaymentAmount($r) }}
                                        <br>
                                        Pending Amount: {{ $r->un_recharge_amount ?? 0 }}
                                    @endif

                                    @if (globalPermission('reseller-client-billing') && in_array('view-client-account-balance', $permissions))
                                        @php($resellerClientBalance = isset($r->customer_account_balance_reseller) ? $r->customer_account_balance_reseller : 0)

                                        @if ($resellerClientBalance >= 0)
                                            <span class="badge bg-danger">
                                                Due: {{ number_format($resellerClientBalance, 2) }}
                                            </span>
                                        @elseif ($resellerClientBalance < 0)
                                            <span class="badge bg-success">
                                                Advance: {{ number_format(abs($resellerClientBalance), 2) }}
                                            </span>
                                        @endif

                                    @endif


                                @endif
                            </p>

                            @if ($r->pops->bill_generate == 'yes')
                                @php($due_amount = isset($r->customerAccount) ? $r->customerAccount->dueAmount : 0);

                                <p class="text-light font-weight-bold text-start"
                                    @if ($due_amount > 0) style="background: #fb7185;"
                                @else
                                    style="background: #008000;" @endif>
                                    @if ($due_amount >= 0)
                                        Due:
                                    @else
                                        Advance:
                                    @endif

                                    <span class="listDue{{ $r->id }} text-start">
                                        @if ($due_amount >= 0)
                                            {{ $due_amount ?? 0 }}
                                        @else
                                            {{ $due_amount * -1 ?? 0 }}
                                        @endif
                                    </span>
                                </p>
                            @endif


                        </div>
                    </td>


                    <td>

                        @if (in_array('show-sub-package', $permissions) && $r->pops->subreseller == 'yes')
                            <span class="d-block mb-1 badge badge-info">{{ $r->subpack->name ?? '' }}
                                @if (in_array('show-sub-package-rate', $permissions))
                                    ({{ $r->subpack->rate ?? '' }})
                                @endif
                            </span>
                        @endif


                        @if (in_array('show-mother-package', $permissions))
                            <span class="d-block badge badge-info p-1"> {{ $r->packages->package_name ?? '' }}
                                @if (in_array('show-motherpackage-rate', $permissions))
                                    ({{ $r->packages->package_rate ?? '' }})
                                @endif
                            </span>
                        @endif


                        @if (in_array('package_change_without_cost', $permissions))
                            <a href="" type="button" data-clientid="{{ $r->id }}"
                                class="btn btn-success btn-sm mt-2 package_change_without_cost" data-toggle="modal"
                                data-target="#package_change_without_cost_modal">
                                Package Change
                            </a>
                        @else
                            @if (in_array('package_change_without_cost_expire', $permissions) && $r->clients_status == 'expired')
                                <a href="" type="button" data-clientid="{{ $r->id }}"
                                    class="btn btn-success btn-sm mt-2 package_change_without_cost"
                                    data-toggle="modal" data-target="#package_change_without_cost_modal">
                                    Package Change
                                </a>
                            @endif
                        @endif


                        @if (checkCrmRansferPermission(request()->path()))
                            <a href="" type="button" data-clientid="{{ $r->id }}"
                                data-crmstatus="{{ $r->crm_status }}"
                                class="d-block btn btn-success btn-sm mt-2 crm_status_change" data-toggle="modal"
                                data-target="#crm_status_change_modal">
                                {{ $r->crm_status }} -> Transfer
                            </a>

                            @if ($r->crm_status == 'Fiber')
                                <a href="{{ route('crm-item-return', $r->id) }}" type="button"
                                    class="d-block btn btn-warning btn-sm mt-2 crm_status_change">
                                    Item Return
                                </a>
                            @endif

                            @if ($r->crm_status == 'Store')
                                <a href="{{ route('crm-item-return-show', $r->id) }}" type="button"
                                    class="d-block btn btn-warning btn-sm mt-2 crm_status_change">
                                    Show Return Item
                                </a>
                            @endif
                            <a href="{{ route('crm-change-history', $r->id) }}" type="button"
                                class="d-block btn btn-primary btn-sm mt-2 crm_status_change">
                                History
                            </a>


                            @if (getLastCRMDate($r->id))
                                Check Date : {{ \Carbon\Carbon::parse(getLastCRMDate($r->id))->format('d-M-Y') }}
                            @endif
                        @endif

                    </td>

                    <td class="no-wrap">
                        @if ($r->pops->experity_check == 'Yes')
                            <span class="d-block badge badge-warning">
                                {{ $r->pops->popname ?? '' }}
                            </span>
                        @else
                            {{ $r->pops->popname ?? '' }}
                        @endif
                    </td>

                    <td>
                        {{ $r->clientsinfo->clients_name ?? '' }}
                    </td>
                    <td>
                        {{ $r->clientsinfo->contact_no ?? '' }}
                    </td>



                    <td style="width:350px;font-size:14px; ">
                        <div class="w-100 overflow-custome" style="max-height: 150px !important;">
                            <p id="container-{{ $r->id }}"
                                onload="addOverFlowOnUserInfo({{ $r->id }});">
                                @if ($r->ip_address)
                                    IP: {{ $r->ip_address ?? '' }},<br>
                                @endif
                                @if ($r->mac)
                                    MAC: {{ $r->mac ?? '' }},<br>
                                @endif
                                @if ($r->distribution_point)
                                    Distribution point: {{ $r->distribution_point ?? '' }},<br>
                                @endif
                                @if ($r->connection_type)
                                    Connection type: {{ $r->connection_type ?? '' }},<br>
                                @endif
                                @if ($r->customer_type)
                                    Client type: {{ $r->customer_type ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->dob)
                                    DOB: {{ $r->clientsinfo->dob ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->father_name)
                                    Father: {{ $r->clientsinfo->father_name ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->mother_name)
                                    Mother: {{ $r->clientsinfo->mother_name ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->national_id)
                                    NID: {{ $r->clientsinfo->national_id ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->passport_no)
                                    Passport: {{ $r->clientsinfo->passport_no ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->division)
                                    Division: {{ $r->clientsinfo->divisions->name ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->district)
                                    District: {{ $r->clientsinfo->districts->name ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->thana)
                                    Upazila: {{ $r->clientsinfo->thanas->name ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->area)
                                    Area :{{ $r->clientsinfo->area ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->road_name)
                                    Road Name: {{ $r->clientsinfo->road_name ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->road_no)
                                    Road No: {{ $r->clientsinfo->road_no ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->block_sector)
                                    Block/Sector: {{ $r->clientsinfo->block_sector ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->building_no)
                                    Building No: {{ $r->clientsinfo->building_no ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->building_name)
                                    Building Name: {{ $r->clientsinfo->building_name ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->flat_no)
                                    Flat No: {{ $r->clientsinfo->flat_no ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->owner_name)
                                    House Owner : {{ $r->clientsinfo->owner_name ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->owner_number)
                                    House Owner No: {{ $r->clientsinfo->owner_number ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->other_contact)
                                    Clients Other Contact : {{ $r->clientsinfo->other_contact ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->email)
                                    <b class="text-primary">Email :</b> {{ $r->clientsinfo->email ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->client_latitude)
                                    Latitude : {{ $r->clientsinfo->client_latitude ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->client_longitude)
                                    Longitude : {{ $r->clientsinfo->client_longitude ?? '' }},<br>
                                @endif

                                @if ($r->clientsinfo->box)
                                    Box :{{ $r->clientsinfo->box ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->cable_type)
                                    Cable Type :{{ $r->clientsinfo->cable_type ?? '' }},<br>
                                @endif
                                @if ($r->required_cable != 0)
                                    Cable(Meter): {{ $r->required_cable ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->olt_pon)
                                    OLT/PON : {{ $r->clientsinfo->olt_pon ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->cable_id)
                                    Cable ID : {{ $r->clientsinfo->cable_id ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->cat_type)
                                    Cable(CAT-5/CAT-6): {{ $r->clientsinfo->cat_type ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->cat_length)
                                    {{ $r->clientsinfo->cat_type ?? 'CAT' }} Length(Meter):
                                    {{ $r->clientsinfo->cat_length ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->onu_serial)
                                    ONU MAC/Pon No/Serial No: {{ $r->clientsinfo->onu_serial ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->olt_pon)
                                    OLT No: {{ $r->clientsinfo->olt_pon ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->olt_no)
                                    OLT Card Slot No: {{ $r->clientsinfo->olt_no ?? '' }},<br>
                                @endif
                                @if ($r->clientsinfo->pon_port)
                                    PON Module Port No: {{ $r->clientsinfo->pon_port ?? '' }}<br>
                                @endif
                                @if ($r->clientsinfo->client_latitude && $r->clientsinfo->client_longitude)
                                    <span class="btn btn-danger btn-sm btn-block clear viewMap w-75 mx-auto"
                                        data-id="{{ $r->clientsinfo->client_latitude }},{{ $r->clientsinfo->client_longitude }}">View
                                        Map</span>
                                @endif
                            </p>
                        </div>

                    </td>

                    <td class="whitespace-nowrap">
                        <strong>CD:</strong> {{ date('d-M-Y h:i:sa', strtotime($r->created_at)) }}<br>
                        @if ($r->clientsinfo->joinDate)
                            <strong>JD:</strong> {{ date('d-M-Y', strtotime($r->clientsinfo->joinDate)) }}
                        @endif
                        @can('billing_start_time')
                            @if ($r->billing_start_date)
                                <strong>Bill Start Date:</strong> {{ date('d-M-Y', strtotime($r->billing_start_date)) }}
                            @endif
                        @endcan
                    </td>
                    @if (request()->path() == 'admin/list/close-list' || request()->path() == 'admin/close-search-list')
                        <td>{{ $r->deleted_at->format('d-M-Y h:s:a') }}</td>
                    @endif
                    <td>{{ $r->clientsinfo->remarks ?? '' }}</td>

                    @if (request()->path() == 'admin/pending-customer')
                        <td>{{ $r->adminUser->name ?? '' }}</td>
                    @endif


                </tr>
                @php($totalOtc += $r->clientsinfo->otc)
                @php($totalMrc += $r->packages->package_rate ?? 0)
                @php($catTotalLength += $r->clientsinfo->cat_length ?? 0)
            @endforeach
            @if (request()->path() == 'admin/list/new-join' ||
                    request()->path() == 'admin/list/close-list' ||
                    request()->path() == 'admin/close-search-list' ||
                    request()->path() == 'admin/newClientSearchReport' ||
                    request()->path() == 'admin/clientSearchReport')

        <tfoot>

            <tr>
                @if (request()->path() == 'admin/clientSearchReport')
                    <td></td>
                @endif

                <td colspan="8" style="text-align: right">Total</td>
                @if (auth()->user()->hasPermissionTo('source_mrc_hide'))
                    <td style="text-align: right">
                        Fiber: {{ $list->sum('required_cable') }} Meter,<br> CAT: {{ $catTotalLength }} Meter,<br>
                        OTC:
                        {{ $totalOtc }} Taka</td>
                @else
                    <td style="text-align: right">
                        Fiber: {{ $list->sum('required_cable') }} Meter,<br> CAT: {{ $catTotalLength }} Meter,<br>
                        OTC:
                        {{ $totalOtc }} Taka <br> MRC: {{ $totalMrc }} TK</td>
                @endif
                @if (checkSettings('radius_customer_bandwidth_limit') == 'enable')
                    <br>
                    <td style="text-align: right">
                        <p>
                            <span class="badge badge-warning">Total D⬇️
                                {{ number_format($list->sum('down_bandwidth') / 1024, 2, '.', '') }} GB
                            </span>
                        </p>

                        <p><span class="badge badge-warning">Total U⬆️
                                {{ number_format($list->sum('up_bandwidth') / 1024, 2, '.', '') }} GB
                            </span>
                        </p>
                        <p><span class="badge badge-warning">Total ⬆️
                                {{ number_format(($list->sum('down_bandwidth') + $list->sum('up_bandwidth')) / 1024, 2, '.', '') }}
                                GB
                            </span>
                            @if (isset($package_limit))
                                <p><span class="badge badge-danger">Total Limit ⬆️
                                        {{ number_format($package_limit / 1024, 2, '.', '') }} GB
                                    </span>
                                </p>
                            @endif
                    </td>

                @endif


                <td colspan="2"></td>

            </tr>
        </tfoot>
        @endif
        </tbody>
        </table>



        @if (request()->path() == 'admin/clientSearchReport')
            <script>
                $(document).ready(function() {

                    $('[id^="clientOnlineButton"]').on('click', function() {

                        var clientUserId = $(this).data('client-id');
                        var url = '{{ route('clientOnlineStatus', ['clientUserId' => ':clientUserId']) }}';
                        url = url.replace(':clientUserId', clientUserId);

                        var clickedButton = $(this);

                        var responseParagraph = $(this).next('.response-paragraph');

                        $.ajax({
                            type: 'GET',
                            url: url,

                            success: function(response) {

                                responseParagraph.text(response.ip_address);
                                clickedButton.hide();
                                if (response.ip_address == 'Offline') {
                                    responseParagraph.css({
                                        'background-color': '#ea580c',
                                        'padding': '1.5px',
                                        'color': '#fff',
                                    })
                                } else {
                                    responseParagraph.css({
                                        'background-color': '#16a34a',
                                        'padding': '1.5px',
                                        'color': '#fff',
                                    })
                                }
                            },
                            error: function(error) {

                                console.error(error);
                            }
                        });
                    });
                });
            </script>
        @endif

    </div>
</div>




<style>
    /* sidebar scroller start*/
    .overflow-custome {
        overflow-y: scroll;
    }

    .overflow-custome::-webkit-scrollbar-track {
        -webkit-box-shadow: inset 0 0 6px rgba(56, 15, 15, 0.3);
        background-color: #f5f5f5;
    }

    .overflow-custome::-webkit-scrollbar {
        width: 6px;
        background-color: #f5f5f5;
    }

    .overflow-custome::-webkit-scrollbar-thumb {
        background-color: #330a0a;
        border: 2px solid #555555;
    }

    /* sidebar scroller end*/
</style>

<style>
    .scrollbar {
        /* max-height: 600px;
        min-height: 600px;
        overflow-x: auto;
        overflow-y: auto;
        border: 1px solid #ddd; */
    }

    .table {
        /* width: 100%;
        table-layout: auto;
        border-collapse: collapse; */
    }

    .table th,
    .table td {
        /* padding: 8px;
        text-align: left;
        border: 1px solid #ddd; */
    }

    .table thead th {
        /* position: sticky;
        top: 0; */
        /* background-color: #212529; */
        /* z-index: 2; */
    }
</style>
