<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class NoBangla implements Rule
{
    public function passes($attribute, $value)
    {
        // Disallow Bangla characters (Unicode U+0980 to U+09FF)
        if (preg_match('/[\x{0980}-\x{09FF}]/u', $value)) {
            return false;
        }

        // Disallow ASCII question mark `?` (ASCII 63)
        if (strpos($value, '?') !== false) {
            return false;
        }

        return true;
    }


    public function message()
    {
        return 'The :attribute field must not contain Bangla characters.';
    }
}
