<?php $__env->startSection('content'); ?>
    <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="card">
            <div class="card-body">



                <div class="label label-info">
                    <h4 class="p-2 inline-block float-left"><?php echo e($page_title); ?> (<?php echo e($r->clients_status); ?>)</h4>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('money-receipt-entry')): ?>
                        <?php if($r->client_approval == 'approved' && !globalPermission('payment-bill-by-bill')): ?>
                            <?php echo $__env->make('billing.extra.paymentModal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add_other_bill')): ?>
                        <?php echo $__env->make('billing.extra.addBill', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-balance-adjust')): ?>
                        <?php if($r->client_approval == 'approved' && !globalPermission('payment-bill-by-bill')): ?>
                            <?php echo $__env->make('billing.extra.customerBalanceAdjustModal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>


                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr style="background:#78716C !important; color:white;">
                                <th class="col-md-1">ID</th>
                                <th class="col-md-1">Name</th>
                                <th class="col-md-1">User ID</th>
                                <th class="col-md-1">Address</th>
                                <th class="col-md-1">Mobile No</th>
                                <th class="col-md-1">Speed</th>
                                <th class="col-md-1">Taka</th>
                                <th class="col-md-1">C. Date</th>
                                <th class="col-md-1">E. Date</th>
                                <th class="col-md-1">Pop/Zone</th>
                                <th class="col-md-1">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    <?php (printf('CID%04d', $r->id)); ?>
                                </td>
                                <td><?php echo e($r->clients_name); ?></td>
                                <td><?php echo e($r->userid); ?></td>
                                <td>Flat No: <?php echo e($r->flat_no ?? ''); ?> ,
                                    Building Name: <?php echo e($r->building_name ?? ''); ?> ,
                                    Road No: <?php echo e($r->road_no ?? ''); ?> ,
                                    Block/Sector: <?php echo e($r->block_sector ?? ''); ?> ,
                                    Area : <?php echo e($r->area ?? ''); ?>,
                                    Box : <?php echo e($r->box ?? ''); ?>

                                </td>
                                <td><?php echo e($r->contact_no); ?></td>
                                <td><?php echo e($r->package_name); ?></td>

                                <td>Rate: <?php echo e($r->package_rate); ?>

                                    <?php if(checkSettings('parmanent_discount') == 'enable'): ?>
                                        <hr>
                                        P Dis: <?php echo e($r->parmanent_discount); ?>

                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(date('d-M-Y', strtotime($r->created_at))); ?></td>
                                <td id="cExpDate"><?php echo e(date('d-M-Y', strtotime($r->expire_date))); ?></td>
                                <td class="text-center"><?php echo e($r->popname); ?></td>

                                <td>

                                    <?php if($r->bill_generate == 'yes' && getBillingType() != 'day_to_day'): ?>
                                        <form action="<?php echo e(route('billgenerate')); ?>" method="post">
                                            <?php echo csrf_field(); ?>
                                            <input name="id" type="hidden" value="<?php echo e($r->id); ?>">
                                            <button onclick="return confirm('Are you sure you want to Generate Bill?');"
                                                class="btn btn-info btn-sm" type="submit">Generate Monthly Bill</button>
                                        </form>
                                    <?php endif; ?>




                                    <hr>

                                    <hr class="clearfix">

                                    <a href="<?php echo e(route('clients.edit', $r->id)); ?>"
                                        class="btn btn-success btn-xs btn-block">Edit</a>

                                    <?php if($r->client_approval == 'approved'): ?>
                                        <?php if($r->clients_status != 'deactive'): ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-deactivated')): ?>
                                                
                                                
                                                    <a href="#"
                                                        data-id="<?php echo e($r->id); ?>"
                                                        id="deactive<?php echo e($r->id); ?>"
                                                        class="id_deactive deactive<?php echo e($r->id); ?> btn btn-danger btn-block btn-xs">Deactive
                                                    </a>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-reactivate')): ?>
                                                
                                                    <a href="#"
                                                        data-id="<?php echo e($r->id); ?>"
                                                        id="deactive<?php echo e($r->id); ?>"
                                                        class="id_reactive reactive<?php echo e($r->id); ?> btn btn-success btn-block btn-xs">Reactive
                                                    </a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <?php if($r->bill_generate == 'yes'): ?>
            <div class="card">
                <div class="card-header">
                    <h2 class="text-center">Payment Information</h2>
                </div>
                <div class="card-body table-responsive">
                    <table class="table table-bordered">
                        <tr >
                            <td class="text-bold">Service Amount</td>
                            <td class="text-bold">Paid Amount</td>
                            <td class="text-bold">Current Balance</td>
                            <td class="text-bold">OTC Due</td>
                            <td class="text-bold">Total Due Amount</td>
                        </tr>
                        <tr>
                            <td>
                                <p class="alert alert-info"><?php echo e($r->package_rate); ?></p>
                            </td>
                            <td>
                                <p id="totalPaidAmount" class="alert alert-info"><?php echo e($r->totalPaid); ?></p>
                            </td>
                            <td>
                                <p id="totalCurrentAmount" class="alert alert-info">
                                    <?php if($r->dueAmount < 0): ?>
                                        <?php echo e(abs($r->dueAmount) ?? 0); ?>

                                    <?php else: ?>
                                        <?php echo e(0); ?>

                                    <?php endif; ?>
                                </p>
                            </td>
                            <th>
                                <p id="totalOtcAmount" class="alert alert-info listOtcDue<?php echo e($r->id); ?>">
                                    <?php echo e($r->otc_due ?? 0); ?></p>
                            </th>
                            <td>
                                <p id="TotalDueAmount" class="alert alert-info">
                                    <?php if($r->dueAmount < 0): ?>
                                        <?php echo e(0); ?>

                                    <?php else: ?>
                                        <?php echo e($r->dueAmount); ?>

                                    <?php endif; ?>
                                </p>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="card">

        <div class="row">




            <div class="col-md-7" id="paymentHistoryTable">

            </div>

            <div class="col-md-5">
                <h2 class="header text-center">Bill History</h2>
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Id</th>
                                <th>Description</th>
                                <th>Date</th>
                                <th>Amount</th>
                                <?php if(globalPermission('payment-bill-by-bill')): ?>

                                    <th>Paid Amount</th>
                                <?php endif; ?>

                            </tr>
                            <?php $__currentLoopData = $bill_history->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="<?php echo e($history->deleted_at ? 'opacity-50' : ''); ?>">
                                    <td>
                                        <?php if(globalPermission('payment-bill-by-bill')): ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('money-receipt-entry')): ?>
                                                <?php if($history->paid_amount < $history->bill_amount): ?>

                                                    <button data-bill_id="<?php echo e($history->id); ?>" data-bill_client_id="<?php echo e($history->client_id); ?>" data-bill_amount="<?php echo e($history->bill_amount - $history->paid_amount); ?>"
                                                        type="button" class="btn btn-warning  billButtonPayment btn-xs btn-block"
                                                        data-toggle="modal" data-target="#paymentModal">
                                                        Payment
                                                    </button>
                                                    <br>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                            <?php if(
                                                    (
                                                        auth()->user()->id == 1 ||
                                                        auth()->user()->can('delete-generated-bill-full-permission') ||
                                                        (
                                                            $history->created_at >= today()->firstOfMonth() &&
                                                            $history->created_at <= today()->lastOfMonth()->addDays(1)
                                                        )
                                                    ) &&
                                                    $history->billing_type != 'deleted' &&
                                                    siteinfo()->bill_by_payment_start_time <= $history->created_at
                                                ): ?>
                                                <a
                                                    onclick="return confirm('Are you sure you want to delete?');"
                                                    class="btn btn-danger btn-xs"
                                                    href="<?php echo e(route('billDeleteBillByBillPayment', $history->id)); ?>"
                                                >
                                                    Delete
                                                </a>
                                            <?php endif; ?>


                                        <?php else: ?>
                                            <?php if(
                                                (auth()->user()->id == 1 ||
                                                    auth()->user()->can('delete-generated-bill-full-permission')) &&
                                                    $history->billing_type != 'deleted'): ?>
                                                <a onclick="return confirm('Are you sure you want to Delete?');"
                                                    class="btn btn-danger btn-xs"
                                                    href="<?php echo e(route('billDelete', $history->id)); ?>">Delete</a>
                                            <?php elseif(
                                                $history->created_at >= today()->firstOfMonth() &&
                                                    $history->created_at <=
                                                        today()->lastofMonth()->addDays(1) &&
                                                    $history->billing_type != 'deleted'): ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete-generated-bill')): ?>
                                                    <a onclick="return confirm('Are you sure you want to Delete?');"
                                                        class="btn btn-danger btn-xs"
                                                        href="<?php echo e(route('billDelete', $history->id)); ?>">Delete</a>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                        <?php endif; ?>






                                        <?php echo e($history->id); ?>

                                    </td>
                                    <td><?php echo e($history->description); ?>

                                        <?php if($history->deleted_at): ?>
                                            <br>
                                            <span class="badge badge-danger">Deleted BY:
                                                <?php echo e(user_list()->where('id',$history->deleted_by)->first()->name ?? ''); ?></span><br>
                                            <span class="badge badge-danger">Delete Time:
                                                <?php echo e($history->deleted_at); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($history->created_at); ?></td>
                                    <td><?php echo e($history->bill_amount); ?></td>
                                    <?php if(globalPermission('payment-bill-by-bill')): ?>
                                        <td><?php echo e($history->paid_amount); ?></td>
                                    <?php endif; ?>


                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td colspan="3">Total</td>
                                <td><?php echo e($bill_history->sum('bill_amount')); ?>TK</td>
                                <?php if(globalPermission('payment-bill-by-bill')): ?>
                                    <td><?php echo e($bill_history->sum('paid_amount')); ?>TK</td>
                                <?php endif; ?>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-balance-adjust')): ?>
                <div class="col-md-6">

                    <h2 class="header text-center">Last 10 Balance Adjustment History</h2>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Description</th>
                                    <th>Date</th>
                                    <th>Adjust by</th>
                                    <th>Amount</th>
                                </tr>
                                <?php $__currentLoopData = $balance_adjustment->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            

                                            <?php echo e($history->id); ?>

                                        </td>
                                        <td><?php echo e($history->description); ?></td>
                                        <td><?php echo e($history->created_at); ?></td>
                                        <td><?php echo e($history->user->name); ?></td>
                                        <td><?php echo e($history->amount); ?></td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td colspan="4">Total</td>
                                    <td><?php echo e($balance_adjustment->sum('amount')); ?>TK</td>
                                </tr>
                            </thead>
                        </table>
                    </div>

                </div>
            <?php endif; ?>
        </div>

    </div>

    <div id="paymenthistory" class="mt-10">


    </div>







<?php $__env->stopSection(); ?>


<?php $__env->startSection('ajax'); ?>
    <style>
        label {
            font-size: 15px !important;
        }
    </style>
    <script>
        $(function() {

            $.get('/admin/paymentLog/' + <?php echo e($r->id); ?>, function(data) {
                $('#paymentHistoryTable').html(data);
            });

            $('.buttonHide').on('click', function() {
                // $(this).hide();
            });

            $('.paymentButton').on('click', function() {
                $('.buttonHide').show();
            });

            $('#payment_month').on('change', function() {
                var month = $('#payment_month').val();
                <?php if(checkSettings('payment_month_show_in_remark') == 'enable'): ?>
                    $('#description').val(month);
                <?php else: ?>
                    $('#description').val('Payment of month : ' + month + '. Bill Month : ' + month);
                <?php endif; ?>
            });

            $('#payment_type').on('change', function() {
                let type = $(this).val();
                if (type == 2) {
                    let otc_due = <?php echo e($r->otc_due ?? 0); ?>;
                    $('#in_amount').attr({
                        "max": otc_due
                    });
                    $('#in_amount').val(otc_due);
                } else {
                    $('#in_amount').removeAttr("max");
                    $('#in_amount').val(0);
                }
            });


            $('.billButtonPayment').on('click', function() {

                let bill_id = $(this).data('bill_id');
                let client_id = $(this).data('bill_client_id');
                let bill_amount = $(this).data('bill_amount');




                $('#billIds').val(bill_id); // Convert array to a comma-separated string
                $('#cid').val(client_id);
                $('#paymentAmount').val(bill_amount);


            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sntlcable/radius-circle/resources/views/billing/payment.blade.php ENDPATH**/ ?>