<?php

namespace App\Services;

use App\Models\Client;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class RadiusClientSync{
    public function syncSingleRadiusClient($id)
    {
        // dd("comes");
        $client = Client::with('pops.nas', 'packages')->where('id', $id)->first();
        if ($client) {
            $expire_date = Carbon::parse($client->expire_date)->addDay($client->payment_dadeline)->format('Y-m-d 00:00:00');
            $today = Carbon::parse(today())->format('Y-m-d 00:00:00');

            // check if client is disable or deactive then add != in reccheck table
            if ($client->clients_status == 'disable' || $client->clients_status == 'deactive') {
                $user1 = DB::table('radcheck')->where('username', $client->userid)->where('attribute', 'Cleartext-Password')->first();
                $user2 = DB::table('radcheck')->where('username', $client->userid)->where('attribute', 'NAS-IP-Address')->first();

                if ($user1 == null) {

                    DB::table('radcheck')->insert([
                        'username' => $client->userid,
                        'attribute' => 'Cleartext-Password',
                        'op' => globalPermission('RadiusExpiration') ? ':=' : '!=',
                        'value' => $client->password
                    ]);
                } else if ($user1->op == ':=') {
                    DB::table('radcheck')->where('username', $client->userid)->where('attribute', 'Cleartext-Password')->update([
                        'op' => globalPermission('RadiusExpiration') ? ':=' : '!=',
                    ]);
                }

                if ($user2 == null) {

                    DB::table('radcheck')->insert([
                        'username' => $client->userid,
                        'attribute' => 'NAS-IP-Address',
                        'op' => globalPermission('RadiusExpiration') ? ':=' : '!=',
                        'value' => $client->pops->nas->nasname
                    ]);
                } else if ($user2->op == ':=') {
                    DB::table('radcheck')->where('username', $client->userid)->where('attribute', 'NAS-IP-Address')->update([
                        'op' => globalPermission('RadiusExpiration') ? ':=' : '!=',
                    ]);
                }

            }

            // check if client is active then add := in reccheck table
            if (($expire_date >= $today) || $client->pops->experity_check == "Yes" || $client->experity_check == "No") {

                $user1 = DB::table('radcheck')->where('username', $client->userid)->where('attribute', 'Cleartext-Password')->first();
                $user2 = DB::table('radcheck')->where('username', $client->userid)->where('attribute', 'NAS-IP-Address')->first();

                $user_reduser_group = DB::table('radusergroup')->where('username', $client->userid)->first();

                if ($user1 == null) {

                    DB::table('radcheck')->insert([
                        'username' => $client->userid,
                        'attribute' => 'Cleartext-Password',
                        'op' => ':=',
                        'value' => $client->password
                    ]);
                } else if ($user1->op == '!=') {
                    DB::table('radcheck')->where('username', $client->userid)->where('attribute', 'Cleartext-Password')->update([
                        'op' => ':=',
                    ]);
                }

                if ($user2 == null) {

                    DB::table('radcheck')->insert([
                        'username' => $client->userid,
                        'attribute' => 'NAS-IP-Address',
                        'op' => ':=',
                        'value' => $client->pops->nas->nasname
                    ]);
                } else if ($user2->op == '!=') {
                    DB::table('radcheck')->where('username', $client->userid)->where('attribute', 'NAS-IP-Address')->update([
                        'op' => ':=',
                    ]);
                }



                    DB::table('radusergroup')->updateOrInsert(
                        ['username' => $client->userid], // where clause
                        [
                            'groupname' => $client->packages->id,
                            'priority' => 1
                        ] // values to update/insert
                    );

                


                $only_expire_date = Carbon::parse($client->expire_date)->format('Y-m-d 00:00:00');



            } else {
                // check if client is expire then add != in reccheck table and also change client status to expire
                $only_expire_date = Carbon::parse($client->expire_date)->format('Y-m-d 00:00:00');


                $user1 = DB::table('radcheck')->where('username', $client->userid)->where('attribute', 'Cleartext-Password')->first();
                $user2 = DB::table('radcheck')->where('username', $client->userid)->where('attribute', 'NAS-IP-Address')->first();

                if ($user1 == null) {

                    DB::table('radcheck')->insert([
                        'username' => $client->userid,
                        'attribute' => 'Cleartext-Password',
                        'op' => globalPermission('RadiusExpiration') ? ':=' : '!=',
                        'value' => $client->password
                    ]);
                } else if ($user1->op == ':=') {

                    DB::table('radcheck')->where('username', $client->userid)->where('attribute', 'Cleartext-Password')->update([
                        'op' => globalPermission('RadiusExpiration') ? ':=' : '!=',
                    ]);
                }

                if ($user2 == null) {

                    DB::table('radcheck')->insert([
                        'username' => $client->userid,
                        'attribute' => 'NAS-IP-Address',
                        'op' => globalPermission('RadiusExpiration') ? ':=' : '!=',
                        'value' => $client->pops->nas->nasname
                    ]);
                } else if ($user2->op == ':=') {
                    DB::table('radcheck')->where('username', $client->userid)->where('attribute', 'NAS-IP-Address')->update([
                        'op' => globalPermission('RadiusExpiration') ? ':=' : '!=',
                    ]);
                }
            }
        } else {

        }
    }
}
