@extends('layout.app')


@section('content')


<div class="card">

    <div class="card-body">
        <form action="{{ route('assignPopUpdate',$user->id) }}" method="POST">
            @method('PUT')
            @csrf

            
            <h2 class="page-header">User Name :
                {{ $user->name }}</h2>

                {{-- {{ dd($user->resellers )}} --}}

                @error('pop_id') <p class="alert alert-danger">{{$message}} </p>@enderror

       
                <table class="table table-bordered table-striped">
                  <tr>
                    <th>ID</th>
                    <th>Pop Name</th>
                    <th>Pop Address</th>
                    <th></th>
                  </tr>
                  @foreach($pops as $r )
                 
                  <tr>
                    
                    <td>{{ $r->id }}</td>
                    <td>{{ $r->popname }}</td>
                    <td>{{ $r->pop_location }}</td>
                    <td>

                      <div class="form-group">

                        <div class="custom-control custom-switch">
                          {{-- <input type="checkbox" class="custom-control-input" id="customSwitch1"> --}}
                          
                          <input class="custom-control-input" id="pop{{$r->id}}" name="pop[]" type="checkbox" value="{{ $r->id }}"                       
                            @foreach($user->pops as $pop)                      
                              @if( $pop->id == $r->id )
                              checked
                              @endif
                            @endforeach
                            >
                          <label class="custom-control-label" for="pop{{$r->id}}"></label>
                        </div>
                        
                      </div>


                      
                    </td>
                  </tr>
                  @endforeach

                </table>  
                
                <div class="form-group">
                  <a href="{{route('user.index')}}" class="btn btn-default"><i class="fa fa-arrow-left"></i> Back</a>
                  <input type="submit" class="btn btn-primary float-right"
                  value="Assign POP">
              </div>


        </form>
    </div>
</div>



@endsection
