<?php

namespace App\Http\Controllers;

use App\Models\ItemCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ItemCategoryController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:inventory-group_index|inventory-group_create',['only' =>['index']]);
        $this->middleware('permission:inventory-group_create',['only' =>['create']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = ItemCategory::paginate('100');
        return view('item_category.index',[
            'page_title' => 'Item Category List',
            'list' => $list,
            'url' => route('item-category.create'),
            'add_button' => 'true',
            'class' => 'btn btn-primary',
            'value' => 'Add New Item Category'
             ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('item_category.create',[
            'page_title'=> 'Add New Item Category'
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:item_categories',
            'short_name' => 'nullable',
            'remarks' => 'nullable',
        ]);

        $unit = new ItemCategory();
        $unit->fill($request->all());
        $unit->creator_user_id = Auth::id();
        $unit->save();
        $request->session()->flash('success_message', 'Item Category Added successfull');
        return redirect()->route('item-category.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ItemCategory  $itemCategory
     * @return \Illuminate\Http\Response
     */
    public function show(ItemCategory $itemCategory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\ItemCategory  $itemCategory
     * @return \Illuminate\Http\Response
     */
    public function edit(ItemCategory $itemCategory)
    {
        return view('item_category.update',[
            'list' => $itemCategory,
            'page_title' => 'Update Item Category Information'
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ItemCategory  $itemCategory
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ItemCategory $itemCategory)
    {
        $this->validate($request, [
            'name' => 'required|unique:item_categories,name,' . $itemCategory->id,
            'short_name' => 'nullable',
            'remarks' => 'nullable',
        ]);
        $itemCategory->fill($request->all());
        $itemCategory->updator_user_id = Auth::id();
        $itemCategory->save();
        $request->session()->flash('success_message', 'Item Category Updated Successfull');
        return redirect()->route('item-category.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ItemCategory  $itemCategory
     * @return \Illuminate\Http\Response
     */
    public function destroy(ItemCategory $itemCategory)
    {
        //
    }
}
