@extends('layout.app')


@section('content')

    <form action="{{ route('item-category.store') }}" method="POST">

        @csrf
        <div class="card">
            <div class="card-body">
            <div class="row">
                <div class="form-group col-md-4">
                    <label for="name" class="">
                        Name*
                    </label>
                    <input type="text" name="name" id="name" value="{{ old('name') }}" class="form-control"
                        placeholder=" Name" autocomplete="off" autofocus>
                    @error('name')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="form-group col-md-4">
                    <label for="bn_name" class="">
                        Name(Bangla)
                    </label>
                    <input type="text" name="bn_name" id="bn_name" value="{{ old('bn_name') }}" class="form-control"
                        placeholder=" bn_name" autocomplete="off" autofocus>
                    @error('bn_name')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="form-group col-md-4">
                    <label for="short_name" class="">
                        Short Name*
                    </label>

                    <input type="text" name="short_name" id="short_name" value="{{ old('short_name') }}"
                        class="form-control" placeholder=" short_name" autocomplete="off" autofocus>
                    @error('short_name')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>


                <div class="form-group col-md-12">
                    <label for="remarks" class="">
                        Remarks
                    </label>

                    <input type="text" name="remarks" id="remarks" value="{{ old('remarks') }}" class="form-control"
                        placeholder=" remarks" autocomplete="off" autofocus>
                    @error('remarks')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
            </div>

                <div class="form-group">
                    @can('inventory-group_store')
                        <button type="submit" class="btn btn-success float-right">
                            Save
                        </button>
                    @endcan
                </div>
            </div>
        </div>
    </form>

    <div class="p-5"></div>

@endsection
