<?php

namespace App\Http\Controllers;

use App\Models\PgwResponseLog;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Http\Request;

class PgwResponseLogController extends Controller
{
    public function index()
    {
        $start= today()->subDay(10);
        $end = today()->endOfDay();
        $logs = PgwResponseLog::whereBetween('created_at',[$start,$end])->orderBy('id','DESC')->get();

        $data = [
            'start' => $start,
            'end' => $end,
            'logs' => $logs
        ];
        return view('pgwResponseLog.index', $data);

    }

    public function pgwResponseLogSearch(Request $request){

       if($request->from_date && $request->to_date){
            $start= Carbon::parse($request->from_date)->format('Y-m-d  00:00:00');
            $end = Carbon::parse($request->to_date)->format('Y-m-d 23:59:59');
            $logs = PgwResponseLog::whereBetween('created_at',[$start,$end])->orderBy('id','DESC')->get();
            $data = [
                'start' => $start,
                'end' => $end,
                'logs' => $logs
            ];
            return view('pgwResponseLog.index', $data);
       }
       Toastr::error('Please Select Date Range');
       return redirect()->back();
    }

   
}
