@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="" id="search">
                <div class="row">
                    <!-- From Date -->
                    <div class="col-md-2 col-sm-2 col-xs-6">
                        <div class="form-group">
                            <label for="from_date" class="block text-gray-700 text-sm font-bold mb-2">From Date</label>
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input
                                    type="text"
                                    name="from_date"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker"
                                    data-target="#searchFrom"
                                    value="{{ $start->format('m/d/y') }}"
                                    autocomplete="off">
                            </div>
                        </div>
                    </div>

                    <!-- To Date -->
                    <div class="col-md-2 col-sm-2 col-xs-6">
                        <div class="form-group">
                            <label for="to_date" class="block text-gray-700 text-sm font-bold mb-2">To Date</label>
                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input
                                    type="text"
                                    name="to_date"
                                    value="{{ $end->format('m/d/y') }}"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker"
                                    data-target="#searchTo"
                                    autocomplete="off">
                            </div>
                        </div>
                    </div>

                    <!-- Manager Name -->
                    <div class="col-md-2 col-sm-2 col-xs-6">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Manager Name</label>
                            <select name="reseller" id="reseller" class="form-control select2 form-control-sm" required>
                                <option value="all">ALL Manager</option>
                                @foreach ($resellers as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <!-- POP Name -->
                    <div class="col-md-2 col-sm-2 col-xs-6">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2">POP Name</label>
                            <select name="pop" id="pop" class="select2 form-control form-control-sm">
                                <option value="all">ALL POP</option>
                            </select>
                        </div>
                    </div>

                    <!-- Payment Type -->
                    <div class="col-md-2 col-sm-2 col-xs-6">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Payment Type</label>
                            <select name="payment_type" id="payment_type" class="select2 form-control form-control-sm">
                                <option value="all">All Type</option>
                                @foreach ($bill_generate_type as $type)
                                    <option value="{{ $type->billing_type }}">{{ $type->billing_type }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <!-- User Name -->
                    <div class="col-md-2 col-sm-2 col-xs-6">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2">User Name</label>
                            <input name="user_name" id="user_name" class="form-control" />
                        </div>
                    </div>
                </div>

                <div class="form-group float-right">
                    <button class="btn btn-primary" type="submit" id="searchBtn">
                        <i class="fa fa-search"></i> Search
                    </button>
                    <button class="btn btn-info" type="reset" id="reset">Reset</button>
                </div>
            </form>
        </div>
    </div>

    <div class="card" id="serarchReport">
        <div class="card-body">
            <button class="btn btn-primary mb-2" onclick="export2csv()">Download CSV</button>

            <div class=" float-right d-flex amount-container" style="text-align:center; gap:3px !important; ">

                <p class="p-1" style="border:2px solid #fed7aa;" id="total_bill_account_client">
                    Total Row: {{ $bill_generates->count() }}
                </p>
                <p class="p-1" style="border:2px solid #fed7aa;" id="total_bill_account_amount">
                    Total Bill: {{ number_format($bill_generates->sum('bill_amount'), 2, '.', '') }}
                </p>
                <p class="p-1" style="border:2px solid #fed7aa;" id="total_bill_account_paid">
                    Total Paid: {{ number_format($bill_generates->sum('paid_amount'), 2, '.', '') }}
                </p>
                <p class="p-1" style="border:2px solid #fed7aa;" id="total_bill_account_due">
                    Total Due: {{ number_format($bill_generates->sum('bill_amount') - $bill_generates->sum('paid_amount'), 2, '.', '') }}
                </p>
            </div>

            <table class="table table-striped table-borderless table-condensed" id="result_table">
                <thead>
                    <tr class="bg-black">
                        <th>Date</th>
                        <th>Client User ID</th>
                        <th>Client Name</th>
                        <th>Type</th>
                        <th class="text-right">Bill</th>
                        <th class="text-right">Paid</th>
                        <th class="text-right">Due</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($bill_generates as $bill)
                        <tr @if ($bill->clients->deleted_at) class="bg-warning" @endif>
                            <td>{{ $bill->created_at->format('M d Y') }}</td>
                            <td>{{ $bill->clients->userid }}</td>
                            <td>{{ $bill->clientsinfo->clients_name }}</td>
                            <td>{{ $bill->billing_type }}</td>
                            <td class="text-right">{{ $bill->bill_amount }}</td>
                            <td class="text-right">{{ $bill->paid_amount }}</td>
                            <td class="text-right">{{ $bill->bill_amount - $bill->paid_amount }}</td>
                        </tr>
                    @endforeach
                    <tr>
                        <td><strong>Total Row</strong></td>
                        <td><strong>{{ $bill_generates->count() }}</strong></td>
                        <td></td>
                        <td><strong>Total Amount</strong></td>
                        <td class="text-right">
                            <strong>{{ number_format($bill_generates->sum('bill_amount'), 2, '.', '') }}</strong>
                        </td>
                        <td class="text-right">
                            <strong>{{ number_format($bill_generates->sum('paid_amount'), 2, '.', '') }}</strong>
                        </td>
                        <td class="text-right">
                            <strong>{{ number_format($bill_generates->sum('bill_amount') - $bill_generates->sum('paid_amount'), 2, '.', '') }}</strong>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
@endsection




@section('ajax')
    <script type="text/javascript">
        $(function() {
            $('#reset').click(function() {
                $("#result_table  tbody").empty();
                $('#pop').html('<option value="all">ALL POP</option>');

                $("#reseller").val('all').change();


            });
            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="loading">Loading.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerAreaPop') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {

                        $('#pop').empty();
                        $('#pop').append('<option value="all"> All Pop </option>');
                        result.pops.forEach(element => {
                            $('#pop').append('<option value="' + element.id + '">' +
                                element.popname + '</option>');
                        });

                        $('#loading').remove();

                    }
                });
            });

            $('#searchBtn').on('click', function(e) {
                e.preventDefault();

                $('body').prepend('<div id="loading">Loading.....</div>');
                let total_due = 0;
                $.ajax({
                    type: 'get',
                    url: '{{ route('bill-generate-search') }}',
                    data: $('#search').serialize(),

                    success: function(result) {

                        $('#serarchReport').html(result);

                        $('#loading').remove();
                    }
                });
            });
        });

        function export2csv() {
            let data = "";
            const tableData = [];
            const rows = document.querySelectorAll("table#result_table tr");
            for (const row of rows) {
                const rowData = [];
                for (const [index, column] of row.querySelectorAll("th, td").entries()) {

                    rowData.push(column.innerText.replace(/[\r\n]/gm, ' '));
                }
                tableData.push(rowData.join(","));
            }
            data += tableData.join("\n");

            // Add UTF-8 BOM for proper Bengali text display in Excel
            const BOM = "\uFEFF";
            const csvContent = BOM + data;

            const a = document.createElement("a");
            a.href = URL.createObjectURL(new Blob([csvContent], {
                type: "text/csv;charset=utf-8;"
            }));
            a.setAttribute("download", "bill_generate_list.csv");
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
    </script>
@endsection

<style>
    .amount-container {
        flex-direction: column;
    }

    @media (min-width:640px) {
        .amount-container {
            flex-direction: row;
        }
    }
</style>
