<div class="d-flex justify-content-between align-items-center mb-2">
    <div>
        <button class="btn btn-primary" onclick="export2csv()">Download CSV</button>
        <button class="btn btn-danger" onclick="export2pdf()">Download PDF</button>
    </div>
    <div class="amount-container d-flex text-center gap-2 flex-wrap">
        <p class="p-1 border" style="border:2px solid #fed7aa;">Total Row: {{ $payments->count() ?? 0 }}</p>
        <p class="p-1 border" style="border:2px solid #fed7aa;">Total Amount: {{ $payments->sum('paid_amount') }} TK</p>
        <p class="p-1 border" style="border:2px solid #fed7aa;">Total Discount: {{ $payments->sum('discount_amount') }}</p>
    </div>
</div>

<div id="paymenthistory" class="mt-3">
    <div class="table-responsive">
        <table class="table table-bordered" id="tableDownload">
            <thead>
                <tr>
                    <th>#ID</th>
                    <th>Date</th>
                    <th>Client Name</th>
                    <th>Username</th>
                    <th>Reseller</th>
                    <th>MR ID</th>
                    <th>Entry By</th>
                    <th>Amount</th>
                    <th>Discount</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($payments as $payment)
                    <tr>
                        <td>{{ $payment->id }}</td>
                        <td class="text-center">{{ date('d-M-Y h:i:s A', strtotime($payment->created_at)) }}</td>
                        <td>{{ optional($payment->clientsinfo)->clients_name ?? $payment->client_id }}</td>
                        <td>{{ optional($payment->client)->userid ?? $payment->client_id }}</td>
                        <td>{{ $payment->reseller->name ?? '' }}</td>
                        <td>{{ $payment->money_receipt_number }}</td>
                        <td>{{ $payment->paymentBy->name ?? '' }}</td>
                        <td>{{ $payment->paid_amount }}</td>
                        <td>{{ $payment->discount_amount }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

<!-- Export Scripts -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://unpkg.com/jspdf-autotable@3.6.0/dist/jspdf.plugin.autotable.js"></script>

<script>
    function export2csv() {
        let data = "";
        const tableData = [];
        const rows = document.querySelectorAll("#tableDownload tr");
        for (const row of rows) {
            const rowData = [];
            for (const [index, column] of row.querySelectorAll("th, td").entries()) {
                if ((index + 1) % 3 === 0) {
                    rowData.push('"' + column.innerText + '"');
                } else {
                    rowData.push(column.innerText);
                }
            }
            tableData.push(rowData.join(","));
        }
        data += tableData.join("\n");
        const a = document.createElement("a");
        a.href = URL.createObjectURL(new Blob([data], { type: "text/csv" }));
        a.setAttribute("download", "payment_report.csv");
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }

    function export2pdf() {
        const { jsPDF } = window.jspdf;
        const doc = new jsPDF({ orientation: 'landscape' });

        doc.text("Reseller Payment History", 14, 10);
        doc.autoTable({
            html: "#tableDownload",
            startY: 20,
            theme: "grid",
            headStyles: { fillColor: [22, 160, 133] },
            styles: { fontSize: 7 },
            tableWidth: 'auto'
        });

        doc.save("payment_report.pdf");
    }
</script>

<style>
    .amount-container {
        flex-direction: column;
    }
    @media (min-width: 640px) {
        .amount-container {
            flex-direction: row;
        }
    }
</style>
