<?php

namespace App\Http\Controllers\Api;

use App\Models\Client;
use App\Models\Billpayment;
use Illuminate\Http\Request;
use App\Services\ClientServices;
use App\Http\Controllers\Controller;
use App\Models\BillGenerate;

class ClientController extends Controller
{
    public function showApi($id)
    {
        $details['userinfo'] =  ClientServices::customerList('singleUser',$id)->get();

        $details['paymentinfo'] = Billpayment::whereClient_id($id)->get();

        // return $details;
        return response()->json($details,200);
    }

    public function getCustomerInfo(Request $request)
    {


        if(!empty($request->userid) && !empty($request->password)){

            $user = Client::with('clientsinfo','pop')->whereUserid($request->userid)->wherePassword($request->password)->first();

            if(!empty($user)){
                $id = $user->id;
                $details['userinfo'] =  $user;
                $details['paymentinfo'] = Billpayment::whereClient_id($id)->get();
                $details['billinginfo'] = BillGenerate::whereClient_id($id)->get();
                return response()->json($details,200);
            }else{
                return response()->json('Nothing Found',404);

            }

        }else{

            return response()->json('No Value passed',404);
        }
    }

    public function totalClient()
    {
        $total =  Client::where('client_approval', 'approved')->count();

        return response()->json($total);
    }
}
