<?php

namespace App\Jobs;

use App\Models\MailLog;
use App\Models\Packages;
use Illuminate\Bus\Queueable;
use App\Models\CustomerAccount;
use App\Mail\PaymentSuccessMail;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Facade\Ignition\Support\Packagist\Package;
use Illuminate\Contracts\Queue\ShouldBeUnique;

class SendPaymentMailJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */

    public $client;
    public $payment;
    public $email_body;

    public function __construct($client,$payment,$email_body)
    {
        $this->client = $client;
        $this->payment = $payment;
        $this->email_body = $email_body;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

        $customerAccount = CustomerAccount::where('client_id',$this->client->id)->first();
        $package = Packages::find($this->client->package_id);
        
        $message = str_replace(
            [
                '{c_id}',
                '{c_username}',
                '{c_name}',
                '{PaymentAmount}',
                '{PaymentDiscount}',
                '{PaymentMethod}',
                '{TotalDue}',
                '{MonthBillAmount}',
                '{MoneyreciptNo}',
                '{TrxId}',
                '{payment_description}',
                '{company_name}',
                '{company_cell}'

            ],
            [
                $this->client->id,
                $this->client->userid,
                $this->client->clientsinfo->clients_name,
                $this->payment->paid_amount,
                $this->payment->discount_amount,
                $this->payment->payment_method,
                $customerAccount->dueAmount > 0 ? $customerAccount->dueAmount : 0,
                $package->package_rate,
                $this->payment->money_receipt_number,
                $this->payment->trx_id,
                $this->payment->description,
                siteinfo()->name,
                siteinfo()->mobile,
            ],
            $this->email_body->email_body
        );

        DB::beginTransaction();

        try {           
            
            $status = Mail::to($this->client->clientsinfo->email)
                ->send(new PaymentSuccessMail($message,$this->client));

            MailLog::create([
                'clients_id' => $this->client->id,
                'subject'   => 'Payment Success Message',
                'message'   => $message,
                'status'    => 'success',
                'error'     => '',
                'to'        => $this->client->clientsinfo->email,
            ]);

            DB::commit();
        } catch (\Swift_TransportException $th) {

            DB::rollback();
            MailLog::create([
                'clients_id' => $this->client->id,
                'subject'    => 'Payment Success Message',
                'message'    => $message,
                'status'     => 'faild',
                'error'      => $th,
                'to'         => $this->client->clientsinfo->email,
            ]);
        }
        
    }
}
