import toast from "react-hot-toast";
import axiosInstance from "../../util/axiosInstance";
import { setBoxClients } from "../reducers/boxClientReducer";

export const fetchBoxClients = () => async (dispatch) => {
    try {
        const { data } = await axiosInstance.get("/clients/getOnlyStatus");
        console.log(data);
        dispatch(setBoxClients(data));
    } catch (error) {
        toast.error("Failed to fetch box clients");
    }
};
