@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            {{-- <form action="{{ route('assignSearch')}}" method="POST" id="search" class="resellerRechargeLog"> --}}
            <form action="" id="search" class="resellerRechargeLog">
                {{-- @csrf --}}
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Select Manager</label>
                            <select name="reseller" id="reseller" class="form-control form-control-sm select2">
                                <option value="">Select One</option>
                                @foreach ($reseller as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label> Select POP </label>
                        <select name="pop" id="pop" class="form-control form-control-sm select2">
                            <option value=""> Select One</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group float-right mt-4">
                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i> Search</button>
                            {{-- <button class="btn btn-primary" type="submit"><i
                                    class="fa fa-search"></i> Search</button> --}}
                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <br>
            <div class="table-responsive" id="result">
                <table id="dataTable" class="table table-bordered table-striped table-condensed">
                    <thead class="bg-gray-50">
                        <tr class="bg-black text-center">
                            <th>ID</th>
                            <th>Token</th>
                            <th>Token Code</th>
                            <th>Date</th>
                            <th>Description</th>
                            <th>Username</th>
                            <th>Address</th>
                            <th>Contact</th>
                            <th>Created By</th>
                            <th>Created By Client</th>
                            <th>Assign To</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($token as $r)
                            <tr>
                                <td>{{ $r->id }}</td>
                                <td>{{ $r->token }}</td>
                                <td>{{ $r->Code->tokenCode ?? '' }}</td>
                                <td>{{ $r->created_at }}</td>
                                <td>{{ $r->description }}</td>
                                <td>{{ $r->clients->userid ?? '' }}</td>
                                <td style="width:350px;">
                                    <p style="font-size:14px;">
                                        @if (!empty($r->clients->clientsinfo->flat_no))
                                            Flat No: {{ $r->clients->clientsinfo->flat_no ?? '' }},
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->building_name))
                                            Building Name: {{ $r->clients->clientsinfo->building_name ?? '' }},<br>
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->road_no))
                                            Road No: {{ $r->clients->clientsinfo->road_no ?? '' }},<br>
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->block_sector))
                                            Block/Sector: {{ $r->clients->clientsinfo->block_sector ?? '' }},
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->area))
                                            Area : {{ $r->clients->clientsinfo->area ?? '' }}, <br>
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->box))
                                            Box : {{ $r->clients->clientsinfo->box ?? '' }}
                                        @endif
                                    </p>
                                </td>
                                <td>{{ $r->reporterContact }}</td>
                                <td>{{ $r->creator->name ?? '' }}</td>
                                <td>{{ $r->createByClient }}</td>
                                <td>
                                    <form action="{{ route('assignStore', $r->id) }}" method="POST" name="editForm">
                                        @csrf
                                        <input type="hidden" name="assignUserId" value="{{ Auth::user()->id }}">
                                        <div class="d-flex justify-content-between">
                                            <select class="select2 mr-1 pr-2 form-control-sm" name="assignToken">
                                                <option value="">Select</option>
                                                @forelse ($employees as $item)
                                                    <option value="{{ $item->id }}">{{ $item->name }} -
                                                        {{ $item->user_id }}</option>
                                                @empty
                                                @endforelse
                                            </select>
                                            <button type="submit" class="btn btn-primary float-right btn-sm">
                                                Assign
                                            </button>
                                        </div>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="p-5">
                {{-- {{ $employees->links() }} --}}
            </div>
        </div>
    </div>
@endsection

@section('ajax')
    <script type="text/javascript">
        $(document).ready(function() {
            $('#dataTable').DataTable();
        });

        $(function() {
            $('#reset').click(function() {
                $('#result').html('');
                $('#pop').html('<option value="all">Select One</option>');
            });

            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $('body').append('<div id="processing">processing.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('assignSearch') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        console.log(result);
                        $('#result').html(result);
                        $('#processing').remove();
                        $('#dataTable').DataTable({
                            'destroy': true,
                        });

                    }
                });
            });


            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="processing">processing.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerPopList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').html(result);
                        $('#processing').remove();
                    }
                });
            });

        });
    </script>
@endsection
