<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ItemController;
use App\Http\Controllers\UnitController;
use App\Http\Controllers\BranchController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\RequisitionController;
use App\Http\Controllers\ItemCategoryController;
use App\Http\Controllers\ItemReturnController;
use App\Http\Controllers\RequisitionApproveController;
use App\Http\Controllers\SerialNumberController;
use App\Http\Controllers\StockAdjustmentController;
use App\Http\Controllers\StockAdjustmentTypeController;
use App\Models\ItemReturn;
use App\Models\SerialNumber;

Route::resource('item', ItemController::class);
Route::resource('item-category', ItemCategoryController::class);
Route::resource('unit', UnitController::class);
Route::resource('branch', BranchController::class);
Route::resource('supplier', SupplierController::class);
Route::resource('purchase', PurchaseController::class);
Route::resource('requisition', RequisitionController::class);
// Route::group(['middleware' => ['can:requisition_approve']], function () {

    Route::get('requisition-pending', [RequisitionController::class, 'pendingRequisition'])->name('requisition.pending');
// });
Route::get('stock', [PurchaseController::class, 'stock'])->name('stock.index');
Route::get('fetch-item-by-search-keyword/{keyword}', [PurchaseController::class, 'getItemBySearchKeyword']);
Route::get('fetch-item-by-item-id/{item_id}', [PurchaseController::class, 'getItemById']);
Route::get('fetch-item-by-category-id/{category_id}', [PurchaseController::class, 'getItemByCategoryId']);
Route::get('fetch-bank-account-by-id/{id}', [PurchaseController::class, 'getBankAccountById']);
Route::resource('requisition-approves', RequisitionApproveController::class);
Route::get('fetch-requisition-by-requisition-id/{id}', [RequisitionApproveController::class, 'getRequisitionByRequisitionId']);
Route::get('requisition-approve/{id}', [RequisitionApproveController::class, 'requisitionApprove'])->name('requisition.approve');
Route::get('serial-no-add/{id}', [PurchaseController::class, 'serialNoAdd'])->name('serial-no-add');
Route::get('add-serial',[SerialNumberController::class, 'addSerial'])->name('add-serial');
Route::get('approve-purchase/{id}',[SerialNumberController::class, 'approvePurchase'])->name('approve-purchase');
Route::get('all-serial',[SerialNumberController::class, 'allSerial'])->name('all-serial');
Route::resource('serialNumber',SerialNumberController::class)->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
Route::post('edit-serial',[SerialNumberController::class,'editSerialNo'])->name('edit-serial')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
Route::post('serial-no-delete',[SerialNumberController::class,'serialNoDelete'])->name('serial-no-delete')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
Route::get('show-all-serial-no/{purchase_id}',[SerialNumberController::class,'showAllSerialNo'])->name('show-all-serial-no');
Route::get('get-serial-number',[SerialNumberController::class,'getSerialNumber'])->name('get-serial-number');
Route::resource('item-return',ItemReturnController::class);
Route::get('get-item',[ItemReturnController::class,'getItem'])->name('get-item');
Route::get('show-serial-no/{id}',[PurchaseController::class,'showSerialNo'])->name('show-serial-no');
Route::resource('adj-type',StockAdjustmentTypeController::class);
Route::resource('adjustment',StockAdjustmentController::class);
Route::get('serial-no-show-all/{id}',[SerialNumberController::class,'serialNoShowAll'])->name('serial-no-show-all');
Route::get('serial-number/{p_id}/{i_id}', [SerialNumberController::class,'allSerialNumber'])->name('serial-number');
Route::get('add-item-card', [PurchaseController::class,'addItemCard'])->name('add-item-card');
