{{-- @dd($smsLog) --}}
@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="" id="search">

                <div class="row">
                    <div class="col-md-3 col-sm-3 col-xs-6">
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" >
                                Manager Name
                            </label>
                            <select name="reseller" id="reseller" class="form-control select2 form-control-sm" required>
                                <option value="all">ALL Manager</option>
                                @foreach ($resellers as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3 col-sm-3 col-xs-6">
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" >
                                Select Type
                            </label>
                            <select name="type" id="type" class="form-control select2 form-control-sm" required>
                                <option value="all">ALL</option>
                                @foreach ($types as $type)
                                    <option value="{{ $type }}">{{ $type }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3 col-sm-3 col-xs-6">
                        <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                            From Date
                        </label>
                        <div class="input-group date" id="searchFrom" data-target-input="nearest">
                            <input type="text" name="from_date" class="form-control datetimepicker-input input-group-append" data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">

                        </div>
                    </div>

                    <div class="col-md-3 col-sm-3 col-xs-6">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                To Date
                            </label>
                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input type="text" name="to_date"  class="form-control datetimepicker-input input-group-append" data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                            </div>
                        </div>
                    </div>


                </div>
                <div class="form-group float-right">
                    <button  class="btn btn-primary" type="submit" id="searchBtn"><i class="fa fa-search"></i> Search</button>
                    <button class="btn btn-info" type="reset" id="reset">Reset</button>
                </div>

            </form>



            <div class="table-responsive" id="result">
                <div class="float-left">
                    {{ $logs->links() }}
                </div>
                <table id="" class="display table table-bordered table-striped table-sm">
                    <thead class="bg-gray">
                        <tr>
                            <th scope="col">ID</th>
                            <th scope="col">Reseller</th>
                            <th scope="col">Contact</th>
                            <th scope="col" style="max-width: 40%" >Message</th>
                            <th scope="col" >Type</th>
                            <th scope="col" style="max-width: 20%">Delivery Message</th>
                            <th scope="col">Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($logs as $item)
                            <tr>
                                <td>{{ $item->id }}</td>
                                <td>{{ $item->reseller->name }}</td>
                                <td>{{ $item->contact }}</td>
                                <td style="max-width: 40%">{{ $item->message }}</td>
                                <td>{{ $item->type }}</td>
                                <td style="max-width: 20%">{!! checkSmsStatus($item->delivery_message) !!}</td>
                                <td>{{ $item->created_at }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $logs->links() }}
            </div>
        </div>
        <div class="card-footer">

        </div>
    </div>
@endsection

@section('ajax')
    <script type="text/javascript">
        $(document).ready(function() {
            $('#dataTable').DataTable();


            $('#searchBtn').on('click', function(e) {
                e.preventDefault();

                $('body').prepend('<div id="loading">Loading.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('reseller-sms-log-search') }}',
                    data: $('#search').serialize(),

                    success: function(result) {
                        $('#result').html(result);
                        $('#loading').remove();
                    }
                });
            });
        });

    </script>
@endsection
