@extends('layout.app')

@section('title', 'QR Code Generator')

@section('content')
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title mb-0">QR Code Generator</h3>
                </div>
                <div class="card-body">
                    <form method="GET" action="{{ route('qr.generator') }}">
                        <div class="form-group">
                            <label for="text">Text to encode</label>
                            <input type="text" name="text" id="text" class="form-control"
                                placeholder="Type any text, URL, phone number, etc." value="{{ old('text', $text) }}"
                                required>
                            @error('text')
                                <small class="text-danger d-block mt-1">{{ $message }}</small>
                            @enderror
                        </div>

                        <div class="d-flex align-items-center gap-2">
                            <button type="submit" class="btn btn-primary mr-2">Generate QR</button>
                            @if ($qrCode)
                                <a class="btn btn-outline-secondary" href="{{ route('qr.generator') }}">Clear</a>
                            @endif
                        </div>
                    </form>
                </div>

                @if ($qrCode)
                    <div class="card-footer text-center bg-white">
                        <p class="mb-2">Preview for: <strong>{{ $text }}</strong></p>
                        <div class="d-inline-block p-2 bg-white border rounded shadow-sm">
                            {!! $qrCode !!}
                        </div>
                        <div class="mt-3">
                            <a class="btn btn-sm btn-success" href="{{ $qrCodeDownload }}" download="qr-code.svg">
                                Download SVG
                            </a>
                        </div>
                        <p class="text-muted mt-2 mb-0">Right-click and save, or use Download SVG.</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection

