<?php

namespace App\Jobs;

use App\Services\BatchPopChangeService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class BatchPopChangeJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $clients;
    private $newPopId;
    private $authUserId;

    public function __construct($clients, $newPopId, $authUserId)
    {
        $this->clients = $clients;
        $this->newPopId = $newPopId;
        $this->authUserId = $authUserId;
    }

    public function handle()
    {
        $service = new BatchPopChangeService();

        foreach ($this->clients as $client) {
            $service->batchPopChange($client, $this->newPopId, $this->authUserId);
        }
    }
}

