<?php

namespace App\Http\Controllers;

use App\Models\Pop;
use App\Models\Reseller;
use App\Models\ResellerArea;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ResellerAreaController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:reseller_area_index|reseller_area_create',['only' => ['index']]);
        $this->middleware('permission:reseller_area_create',['only' => ['create']]);
    }

    public function index()
    {
        $id = auth()->id();

        if (auth()->user()->hasRole('Admin')) {

            $allArea = ResellerArea::paginate(500);
        } elseif (auth()->user()->hasRole(['Reseller Admin', 'Reseller'])) {

            $reseller_ids = DB::table('reseller_user')->where('user_id', $id)->pluck('reseller_id')->toArray();
            $allArea = ResellerArea::whereIn('reseller_id', $reseller_ids)->paginate(500);
        } elseif (auth()->user()->hasRole(['Sub Reseller'])) {

            $pop = DB::table('pop_user')->where('user_id', $id)->pluck('pop_id')->toArray();
            $allArea = ResellerArea::whereIn('pop_id', $pop)->paginate(500);
        } else {

            $allArea = ResellerArea::paginate(500);
        }

        $page_title = 'Manager Area';

        return view('resellerArea.index', [
            'page_title' => $page_title,
            'allArea' => $allArea
        ]);
    }

    public function create()
    {
        $reseller = Reseller::resellerList()->get(); //Reseller::all();

        return view('resellerArea.create', [
            'reseller' => $reseller
        ]);
    }

    public function store(Request $request)
    {
        // $this->validate($request, [
        //     'reseller_id' => 'required|unique:reseller_areas'
        // ]);

        $resellerArea = new ResellerArea();
        $resellerArea->fill($request->all());
        $resellerArea->save();

        return redirect()->back()->with('success_message', 'Information Added Successufll');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $data = [
            'model' => ResellerArea::find($id),
            'reseller' => Reseller::resellerList()->get() // Reseller::all()
        ];

        return view('resellerArea.edit', $data);
    }

    public function update(Request $request)
    {
        $resellerArea = ResellerArea::find($request->id);

        // $this->validate($request, [
        //     'reseller_id' => ['required', 'unique:reseller_areas,reseller_id,' . $resellerArea->id],
        // ]);

        $resellerArea->fill($request->all());
        $resellerArea->update();

        return redirect()->route('reseller-area.index')->with('success_message', 'Information Updated Successufll');
    }

    public function destroy($id)
    {
        $resellerArea = ResellerArea::find($id);
        $resellerArea->delete();

        return redirect()->route('reseller-area.index')->with('success_message', 'Information Deleted Successufll');
    }
}
