<?php

namespace App\Http\Controllers;

use App\Models\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BtrcReportController extends Controller
{
    public function activeUser(Request $request)
    {

        $clients = Client::where('status', 'active')->get()->count();

        $data = [
             $clients,
        ];

        return response()->json($data, 200);

    }

    public function thanaLevel(Request $request)
    {
       $thanaLevel = Client::select('thanas.name', DB::raw('count(clients.id) as total_clients'))
                    ->join('clientsinfo', 'clients.id', '=', 'clientsinfo.client_id')
                    ->join('thanas', 'clientsinfo.thana', '=', 'thanas.id')
                    ->where('clients.status', 'active')
                    ->groupBy('clientsinfo.thana')
                    ->get();


        return response()->json($thanaLevel, 200);
    }
}
