<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSchedulePackageChangesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('schedule_package_changes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('client_id');
            $table->foreignId('old_package_id');
            $table->foreignId('old_sub_package_id')->nullable();
            $table->foreignId('new_package_id');
            $table->foreignId('new_sub_package_id')->nullable();
            $table->dateTime('schedule_date');
            $table->foreignId('schedule_by');
            $table->enum('status',['Failed','Complete','Pending','Deleted'])->default('Pending');
            $table->text('process_description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('schedule_package_changes');
    }
}
