<?php $__env->startSection('css'); ?>
    <!-- DataTables -->
    <link rel="stylesheet" href="<?php echo e(asset('admin/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title" style="color:#115548;">Expense List</h3>
                            <div class="card-tools">

                                

                                <a href="<?php echo e(route('expense-head.create')); ?>"><button class="btn btn-sm btn-primary"><i
                                            class="fa fa-plus-circle" aria-hidden="true"></i> &nbsp; Expense
                                        Type</button></a>


                                <button data-toggle="modal" data-target="#expenseAdd" class="btn btn-sm btn-primary"><i
                                        class="fa fa-plus-circle" aria-hidden="true"></i> &nbsp; Expense</button>

                                <?php if(checkSettings('expense_approve_multiple') == 'enable'): ?>
                                    <button id="approveSelected" class="btn btn-sm btn-primary">Approve</button>
                                <?php endif; ?>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="dataTable" class="display">
                                    <thead>
                                        <tr>
                                            <?php if(checkSettings('expense_approve_multiple') == 'enable'): ?>
                                                <th>
                                                    <input type="checkbox" id="selectAll">
                                                </th>
                                            <?php endif; ?>
                                            <th>#</th>
                                            <th>Status</th>
                                            
                                            <th>Name</th>
                                            <th>Expense Head</th>
                                            <th>Employee</th>
                                            <th>Invoice Number</th>
                                            <th>Date</th>
                                            <th>Amount</th>
                                            <th>Bank Account</th>
                                            <th>Documents</th>
                                            <th>Description</th>
                                            <th>Create By</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->



                    <div class="modal fade" id="expenseAdd" role="dialog" aria-labelledby="exampleModalCenterTitle"
                        aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">Add Expense</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <form method="POST" action="<?php echo e(route('expense.store')); ?>" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <div class="modal-body">


                                        <div class="card-body">

                                            <div class="row">

                                                <div class="col-md-12">
                                                    <label for="shortname">
                                                        Expense Title*
                                                    </label>
                                                    <input type="text" name="name" class="form-control"
                                                        placeholder="Enter Name" required>
                                                </div>

                                                <div class="col-md-12">
                                                    <label for="shortname">
                                                        Expense Head*
                                                    </label>
                                                    <select name="expenseHead" id="expense_head"
                                                        class="form-control select2" required>
                                                        <option value="">Select One</option>
                                                        <?php $__currentLoopData = $expenseHead; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>

                                                <div class="col-md-12" style="display: none" id="employee_block">
                                                    <label for="employee">Select Employee</label>
                                                    <select name="employee" id="employee" class="form-control">
                                                        <option value="">Select Employee</option>
                                                        <?php $__currentLoopData = getEmployesInExpense(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>

                                                <div class="col-md-12" id="invoice">
                                                    <label for="shortname">
                                                        Invoice Number
                                                    </label>
                                                    <input type="text" name="invoice_number" class="form-control"
                                                        placeholder="Enter Invoice Number">
                                                </div>
                                                <div class="col-md-12">

                                                    <label for="shortname">
                                                        Date*
                                                    </label>


                                                    <div class="input-group date" id="searchFrom"
                                                        data-target-input="nearest">
                                                        <input type="text" name="date"
                                                            class="form-control datetimepicker-input input-group-append"
                                                            data-toggle="datetimepicker" data-target="#searchFrom"
                                                            autocomplete="off">
                                                    </div>



                                                    
                                                </div>
                                                
                                                <div class="col-md-12">
                                                    <label for="shortname">
                                                        Amount*
                                                    </label>
                                                    <input type="number" name="amount" class="form-control"
                                                        placeholder="Enter Amount" required>
                                                </div>
                                                <div class="col-md-12 mt-2">
                                                    <label for="shortname">Attach Document</label>
                                                    <input type="file" name="attach_document">
                                                </div>
                                                <?php if(checkSettings('bank_account_withdraw') == 'enable'): ?>
                                                <div class="col-md-12 mt-2">
                                                    <div class="form-group">
                                                        <label for="expense_bank_account_id">
                                                            Bank Account (Optional)
                                                        </label>
                                                        <select name="bank_account_id" id="expense_bank_account_id" class="form-control">
                                                            <option value="">Select Bank Account</option>
                                                            <?php
                                                                $bankAccounts = \App\Models\Banking::where('status', 1)->get();
                                                            ?>
                                                            <?php if($bankAccounts->count() > 0): ?>
                                                                <?php $__currentLoopData = $bankAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bankAccount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($bankAccount->id); ?>"><?php echo e($bankAccount->account_name); ?> -- <?php echo e($bankAccount->bank_name); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php endif; ?>
                                                        </select>
                                                        <small class="text-muted">If selected, expense amount will be withdrawn from this account.</small>
                                                    </div>
                                                </div>
                                                <?php endif; ?>
                                                <div class="col-md-12">
                                                    <label for="shortname">
                                                        Description
                                                    </label>
                                                    <textarea name="description" class="form-control" placeholder="Type Description"></textarea>
                                                </div>

                                            </div>
                                        </div>


                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary"
                                            data-dismiss="modal">Close</button>
                                        <button type="submit" class="btn btn-primary">Add Expense</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
            <!-- /.row -->

        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('ajax'); ?>
    <script>
        $(function() {

            $('#expense_head').on('change', function() {
                let type = $('#expense_head').val();
                console.log(type);
                // if (type == 1) {
                $('#employee_block').show();
                // $('#invoice').hide();
                // } else {
                // $("#employee option:selected").prop("selected", false)
                // $('#employee_block').hide();
                $('#invoice').show();
                // }
            });


            // Initialize server-side DataTables
            <?php
                $orderColumnIndex = checkSettings('expense_approve_multiple') == 'enable' ? 1 : 0;
            ?>

            // Destroy existing DataTable instance if it exists
            if ($.fn.DataTable.isDataTable('#dataTable')) {
                $('#dataTable').DataTable().destroy();
            }

            var table = $('#dataTable').DataTable({
                "processing": true,
                "serverSide": true,
                "ajax": {
                    "url": "<?php echo e(route('expense.data')); ?>",
                    "type": "GET",
                    "error": function(xhr, error, code) {
                        console.log('Error:', error, code);
                        alert('Error loading data. Please refresh the page.');
                    }
                },
                "columns": [
                    <?php if(checkSettings('expense_approve_multiple') == 'enable'): ?>
                    {
                        "data": "checkbox",
                        "name": "checkbox",
                        "orderable": false,
                        "searchable": false,
                        "render": function(data, type, row) {
                            return '<input type="checkbox" class="selectRow" data-id="' + row.id + '">';
                        }
                    },
                    <?php endif; ?>
                    { "data": "id", "name": "id" },
                    { "data": "status", "name": "status", "orderable": true, "searchable": false },
                    { "data": "name", "name": "name" },
                    { "data": "expense_head", "name": "expense_head" },
                    { "data": "employee", "name": "employee" },
                    { "data": "invoice_number", "name": "invoice_number" },
                    { "data": "date", "name": "date" },
                    { "data": "amount", "name": "amount" },
                    { "data": "bank_account", "name": "bank_account", "orderable": false, "searchable": false },
                    { "data": "document", "name": "document", "orderable": false, "searchable": false },
                    { "data": "description", "name": "description" },
                    { "data": "created_by", "name": "created_by" },
                    { "data": "action", "name": "action", "orderable": false, "searchable": false }
                ],
                "order": [[<?php echo e($orderColumnIndex); ?>, "desc"]],
                "pageLength": 25,
                "lengthMenu": [[10, 25, 50, 100], [10, 25, 50, 100]],
                "searchDelay": 500,
                "responsive": true,
                "autoWidth": false
            });


        });

        // Select all checkboxes (using event delegation for dynamically loaded rows)
        $(document).on('change', '#selectAll', function() {
            var isChecked = $(this).prop('checked');
            $('.selectRow').prop('checked', isChecked);
        });

        // Approve all selected expenses
        $('#approveSelected').on('click', function() {
            let selectedIds = [];

            $('.selectRow:checked').each(function() {
                selectedIds.push($(this).data('id'));
            });

            if (selectedIds.length === 0) {
                alert('Please select at least one expense to approve');
                return;
            }

            if (confirm('Are you sure you want to approve all selected expenses?')) {
                // Send AJAX request to approve multiple expenses
                $.ajax({
                    url: "<?php echo e(route('expense-approve-multiple')); ?>",
                    method: 'POST',
                    data: {
                        ids: selectedIds,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    success: function(response) {
                        location.reload();
                    },
                    error: function(xhr) {
                        alert('Error approving expenses');
                    }
                });

            }
        });
    </script>
    <!-- DataTables -->
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/powermedia/radius-circle/resources/views/accounts/expense/index.blade.php ENDPATH**/ ?>