@extends('Customer.customer-layout')


@section('body')
    @include('Customer.left-menu')

    <main id="main" class="main">

        <div class="pagetitle">
            <h1>Create token</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('customerDashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Create token</li>
                </ol>
            </nav>
        </div><!-- End Page Title -->

        <section class="section profile">
            <div class="row">



                <div class="col-xl-8">

                    <div class="card">
                        <div class="card-body pt-3">
                            <!-- Bordered Tabs -->

                            <div class="tab-content pt-2">



                                <!-- Profile Edit Form -->
                                <form action="{{ route('customer-token.store') }}" method="POST">
                                    @csrf

                                    <div class="row mb-3">
                                        <label for="fullName" class="col-md-4 col-lg-3 col-form-label">Token
                                            Category</label>
                                        <div class="col-md-8 col-lg-9">
                                            <select name="tokenCategory" id="tokenCategory" class="form-control bSelect" required>
                                                <option value="">Select Token Category</option>

                                                @foreach ($tokenCategory as $item)
                                                    <option value="{{ $item->id }}">{{ $item->tokenCategory }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label for="fullName" class="col-md-4 col-lg-3 col-form-label">Token Code</label>
                                        <div class="col-md-8 col-lg-9">
                                            <select name="tokenCode" id="tokenCode" class="form-control bSelect" required>
                                                <option value="all">Select One</option>
                                                
                                                @foreach ($tokenCode as $item)
                                                    <option value="{{ $item->id }}">{{ $item->tokenCode }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label for="company" class="col-md-4 col-lg-3 col-form-label">Description</label>
                                        <div class="col-md-8 col-lg-9">
                                            <input name="description" id="name" type="text" class="form-control" value=""
                                                placeholder="Description" required>
                                        </div>
                                    </div>



                                    <div class="text-center">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                </form><!-- End Profile Edit Form -->




                            </div><!-- End Bordered Tabs -->

                        </div>
                    </div>

                </div>
            </div>
        </section>

    </main><!-- End #main -->
@endsection
