<?php

namespace App\Http\Controllers\Pop;

use App\Classes\EditLogHistory;
use App\Models\Pop;
use App\Models\Client;
use App\Jobs\ClientSyncJob;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Controllers\SessionRefreshController;
use App\Jobs\PopDisableJob;
use App\Jobs\PopEnableJob;
use Illuminate\Support\Facades\Artisan;

class PopEnableDisableController extends Controller
{
    public function pop_disable(Request $request)
    {
        if ($request->ajax()) {

            DB::beginTransaction();
            try {
                $type = 'POP';
                $old_info = Pop::where('id', $request->id)->first();

                $pop = Pop::find($request->id);
                $pop->pop_disable = 'yes';
                $pop->save();


                $users = Client::with('clientsinfo:id,client_id,contact_no')->where('pop_id', $request->id)
                    ->where('clients_status', '!=', 'deactive')
                    ->get();

                Client::where('pop_id', $request->id)
                    ->where('clients_status', '!=', 'deactive')
                    ->update([
                        'clients_status' => 'disable'
                    ]);

                DB::table('radcheck')
                    ->whereIn('username', $users->pluck('userid'))
                    ->update([
                        'op' => '!='
                    ]);

                DB::commit();

                $new_info = Pop::find($pop->id);
                (new EditLogHistory)->editLogSave($pop, $type, $old_info, $new_info);

                PopDisableJob::dispatch($users->pluck('userid'), $pop->id);

                clearCache('pop');
                return true;
            } catch (\Throwable $th) {
                DB::rollBack();
                dd($th);
                return false;
            }
        } else {
            return false;
        }
    }

    public function pop_enable(Request $request)
    {
        if ($request->ajax()) {

            DB::beginTransaction();
            try {
                $type = 'POP';
                $old_info = Pop::where('id', $request->id)->first();
                
                $pop = Pop::find($request->id);
                $pop->pop_disable = 'no';
                $pop->save();


                $users = Client::with('clientsinfo:id,client_id,contact_no')->where('pop_id', $request->id)
                    ->where('clients_status', '!=', 'deactive')
                    ->where('clients_status', '!=', 'expired')
                    ->select('id', 'userid')
                    ->get();

                Client::where('pop_id', $request->id)
                    ->where('clients_status', '!=', 'deactive')
                    ->where('clients_status', '!=', 'expired')
                    ->update([
                        'clients_status' => 'active'
                    ]);

                DB::table('radcheck')
                    ->whereIn('username', $users->pluck('userid'))
                    ->update([
                        'op' => ':='
                    ]);

                DB::commit();

                $new_info = Pop::find($pop->id);
                (new EditLogHistory)->editLogSave($pop, $type, $old_info, $new_info);

                clearCache('pop');

                PopEnableJob::dispatch($pop->id);
                try{
                    Artisan::call('expire:check');
                }catch(\Throwable $th){

                }

                return true;

            } catch (\Throwable $th) {
                DB::rollBack();

                dd($th);
                return false;
            }
        } else {
            return false;
        }
    }
}
